"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// src/server/index.ts
var import_fastify = __toESM(require("fastify"));
var import_jwt = __toESM(require("@fastify/jwt"));
var import_cors = __toESM(require("@fastify/cors"));
var import_multipart = __toESM(require("@fastify/multipart"));

// src/modules/validations/user.ts
var import_zod2 = __toESM(require("zod"));

// src/modules/validations/index.ts
var import_zod = require("zod");
var nonEmptyString = (message) => import_zod.z.string({ required_error: message }).trim().min(1, { message });
var angolanPhoneSchema = import_zod.z.string().regex(/^9[123456789]\d{7}$/, {
  message: "O n\xFAmero de telefone deve ser v\xE1lido e come\xE7ar com 9 seguido de 8 d\xEDgitos."
});
var permissionSchema = import_zod.z.object({
  permissao: import_zod.z.enum(["CRIAR", "VISUALISAR", "EDITAR", "ELIMINAR"]),
  caminho_tela: nonEmptyString("Seleccione uma tela")
});

// src/modules/validations/user.ts
var UserValidations = class {
  getData = import_zod2.default.object({
    nome: nonEmptyString("Introduza o nome"),
    telefone: angolanPhoneSchema,
    email: nonEmptyString().email("Introduza um email v\xE1lido"),
    email_recuperacao: import_zod2.default.string().email("Introduza um email v\xE1lido").optional(),
    senha: nonEmptyString("Introduza a senha")
  });
  getDataToUpdate = this.getData.partial();
  getForLogin = import_zod2.default.object({
    identification: import_zod2.default.string(),
    password: import_zod2.default.string().min(8, "A senha deve possuir no m\xEDnimo 8 caracteres")
  });
};
var userValidations = new UserValidations();

// src/modules/errors/handler.ts
var import_library = require("@prisma/client/runtime/library");

// src/modules/errors/app.ts
var AppError = class extends Error {
  statusCode;
  isOperational;
  details;
  constructor(message, statusCode = 500, isOperational = true, details) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
    this.statusCode = statusCode;
    this.isOperational = isOperational;
    this.details = details;
    Error.captureStackTrace(this);
  }
};

// src/modules/errors/prisma.ts
var import_client = require("@prisma/client");

// src/modules/lib/utils.ts
function formatCamelCaseToTitle(text) {
  if (!text) return "";
  const spacedText = text.replace(/([A-Z])/g, " $1");
  return spacedText.trim().replace(/^./, (str) => str.toUpperCase());
}

// src/modules/errors/prisma.ts
var PrismaErrorHandler = class {
  /**
   * Handles errors thrown by the Prisma client and converts them into
   * user-friendly application errors.
   *
   * This method checks the type of error and returns an instance of
   * `AppError` with a specific message and HTTP status code based on
   * the error code received from Prisma.
   *
   * @param {any} error - The error object thrown by the Prisma client.
   *
   * @returns {AppError} An instance of `AppError` with a message and
   * status code corresponding to the type of error encountered.
   *
   * @throws {AppError} Throws an `AppError` for known Prisma errors:
   * - P2002: Indicates a unique constraint violation.
   * - P2025: Indicates that a record was not found.
   * - P1001: Indicates a database connection error.
   *
   * @example
   * const error = new Prisma.PrismaClientKnownRequestError('...', { code: 'P2002', meta: { modelName: 'User' } });
   * const appError = handle(error);
   * console.log(appError.message); // Outputs: "Este(a) User já existe."
   */
  static handle(error) {
    if (error instanceof import_client.Prisma.PrismaClientKnownRequestError) {
      if (error.code === "P2002") {
        const field = error.meta?.modelName || "";
        return new AppError(
          `Este(a) ${formatCamelCaseToTitle(field)} j\xE1 existe.`,
          409
        );
      }
      if (error.code === "P2025") {
        return new AppError("Registro n\xE3o encontrado.", 404);
      }
      if (error.code === "P1001") {
        return new AppError("Erro ao comunicar com o banco de dados.", 500);
      }
    }
    return new AppError("Erro de banco de dados.", 500);
  }
};

// src/modules/errors/handler.ts
var import_zod3 = require("zod");

// src/modules/errors/zod.ts
var ZodErrorHandler = class {
  static handle(error) {
    const formattedErrors = error.errors.map((err) => ({
      path: err.path.join("."),
      message: err.message
    }));
    return new AppError("Erro de valida\xE7\xE3o", 400, true, formattedErrors);
  }
};

// src/modules/errors/handler.ts
var ErrorsHandler = class {
  static handle(error, res) {
    let appError;
    console.log("Erro:", error);
    if (error instanceof import_library.PrismaClientKnownRequestError || error instanceof import_library.PrismaClientUnknownRequestError) {
      appError = PrismaErrorHandler.handle(error);
    } else if (error instanceof import_zod3.ZodError) {
      appError = ZodErrorHandler.handle(error);
    } else if (error instanceof AppError) {
      appError = error;
    } else {
      console.error("Erro n\xE3o operacional:", error);
      appError = new AppError("Erro interno do servidor", 500, false);
    }
    if (!appError.isOperational) {
      console.error("Erro n\xE3o operacional:", error);
    }
    res.status(appError.statusCode).send({
      status: "error",
      message: appError.message
    });
  }
};

// src/modules/lib/prisma.ts
var import_client2 = require("@prisma/client");
var prisma = new import_client2.PrismaClient({
  log: ["error", "warn", "query"]
});
var prisma_default = prisma;

// src/modules/models/base/index.ts
var BaseModel = class {
  model;
  include;
  getAllWherClause;
  orderBy;
  // Propriedade opcional para definir relações que devem ser incluídas nas consultas.
  /**
   * Cria um novo registro no banco de dados.
   * @param data Os dados necessários para criar o registro, exceto o campo `id` (pois é gerado automaticamente).
   * @returns O registro criado com as relações incluídas, se especificadas.
   */
  async create(data) {
    return await this.model.create({ data });
  }
  /**
   * Busca um registro único pelo ID.
   * @param id O identificador único do registro.
   * @returns O registro correspondente ao ID ou `null` se não encontrado.
   */
  async getById(id) {
    return await this.model.findUnique({
      where: { id },
      include: this.include
    });
  }
  /**
   * Recupera uma lista de registros do banco de dados sem incluir relações.
   * @returns Uma lista de registros sem relações incluídas.
   */
  async getAllWithoutIncludes({ skip, take } = {}) {
    return await this.model.findMany({
      skip,
      take,
      orderBy: this.orderBy
    });
  }
  /**
   * Recupera uma lista de registros do banco de dados com suporte a paginação.
   * @param skip Número de registros a pular (offset).
   * @param take Número máximo de registros a retornar (limit).
   * @returns Uma lista de registros com as relações incluídas, se especificadas.
   */
  async getAll({ skip, take } = {}) {
    return await this.model.findMany({
      skip,
      take,
      include: this.include,
      orderBy: this.orderBy
    });
  }
  /**
   * Conta o número total de registros no banco de dados, aplicando filtros se fornecidos.
   * @param params Parâmetros para o método `count` do Prisma, incluindo condições de filtro (`where`).
   * @returns O número total de registros que atendem aos critérios fornecidos.
   */
  async count(params) {
    return await this.model.count(params || { where: this.getAllWherClause });
  }
  /**
   * Atualiza os dados de um registro existente no banco de dados.
   * @param id O identificador único do registro a ser atualizado.
   * @param data Os dados atualizados a serem aplicados no registro.
   * @returns O registro atualizado com as relações incluídas, se especificadas.
   */
  async update(id, data) {
    console.log("DATA", data);
    return await this.model.update({
      where: { id },
      data,
      include: this.include
    });
  }
  /**
   * Deleta um registro do banco de dados pelo ID.
   * @param id O identificador único do registro a ser deletado.
   * @returns O registro deletado com as relações incluídas, se especificadas.
   */
  async delete(id) {
    return await this.model.delete({ where: { id } });
  }
};

// src/modules/models/user.ts
var userIncludes = {
  cartao_usuario: true,
  trocas: {
    include: {
      referencia: true
    }
  }
};
var UserModel = class extends BaseModel {
  model = prisma_default.usuario;
  include = userIncludes;
  create = async (data) => {
    return await this.model.create({ data, include: this.include });
  };
  getAll = async ({ skip, take, filter }) => {
    this.getAllWherClause = {
      OR: [
        {
          nome: {
            contains: filter
          }
        },
        {
          email: {
            contains: filter
          }
        }
      ]
    };
    return await this.model.findMany({
      include: this.include,
      skip,
      take,
      where: this.getAllWherClause
    });
  };
  getByEmail = async (email) => {
    return await prisma_default.usuario.findFirst({
      where: { email },
      include: this.include
    });
  };
};
var userModel = new UserModel();

// src/modules/services/hash.ts
var import_bcryptjs = __toESM(require("bcryptjs"));
var import_crypto = require("crypto");
var HashService = class {
  hashPassword = async (password) => {
    const saltRounds = 10;
    return await import_bcryptjs.default.hash(password, saltRounds);
  };
  comparePassword = async (password, hash) => {
    return await import_bcryptjs.default.compare(password, hash);
  };
  generatePassword = async () => {
    const length = 10;
    const charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789#$%&";
    let password = "";
    for (let i = 0; i < length; i++) {
      const at = Math.floor(Math.random() * (charset.length + 1));
      password += charset.charAt(at);
    }
    return password;
  };
  generateKeys = () => {
    const { publicKey } = (0, import_crypto.generateKeyPairSync)("rsa", {
      modulusLength: 4096,
      publicKeyEncoding: {
        type: "spki",
        format: "pem"
      },
      privateKeyEncoding: {
        type: "pkcs8",
        format: "pem"
      }
    });
    const cleanKey = (key) => key.replace(/-----BEGIN (PUBLIC) KEY-----\n/, "").replace(/\n-----END (PUBLIC) KEY-----\n/, "").replace(/\n/g, "");
    return {
      publicKey: cleanKey(publicKey)
    };
  };
};
var hashService = new HashService();

// src/modules/services/auth.ts
var AuthService = class {
  /**
   * Authenticates a user based on the provided request and response objects.
   *
   * This method verifies the presence and validity of an access token in the request cookies.
   * It decodes the token, retrieves the user's public key, and verifies the token's signature.
   * If authentication is successful, the user information is attached to the request object.
   *
   * @param req - The Fastify request object containing user credentials and tokens.
   * @param res - The Fastify reply object used to send responses.
   *
   * @returns A promise that resolves to the Fastify reply object with appropriate status and message.
   *
   * @example
   * // Successful authentication
   * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
   *   await authenticate(req, res);
   *   if (req.user) {
   *     console.log('Authenticated user:', req.user);
   *   }
   * }
   *
   * @example
   * // Handling missing token
   * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
   *   const response = await authenticate(req, res);
   *   if (response.statusCode === 401) {
   *     console.log(response.message); // "Precisa de autenticação"
   *   }
   * }
   *
   * @example
   * // Handling invalid or expired token
   * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
   *   try {
   *     await authenticate(req, res);
   *   } catch (error) {
   *     console.error('Authentication failed:', error);
   *     // Handle invalid or expired token
   *   }
   * }
   */
  authenticate = async (req, res) => {
  };
  // authorization = async (req: FastifyRequest, res: FastifyReply) => {
  //   try {
  //     this.authenticate(req, res);
  //     if (!req.user) {
  //       throw new AppError("Precisa de autenticação", 401);
  //     }
  //     const { id } = req.user;
  //     const user = await userModel.getById(id) as User;
  //     if (!user) {
  //       throw new AppError("Usuário não encontrado", 404);
  //     }
  //     user.nivel.permissoes_telas.map((permission) => {
  //       if(permission.tela.caminho == req.url){
  //         if(permission.permissao == "LER"){
  //           if(req.method != "GET"){
  //             throw new AppError("Você não tem permissão para realizar essa ação", 403);
  //           }
  //         }
  //       }
  //     })
  //   } catch (error) {
  //     ErrorsHandler.handle(error, res);
  //   }
  // };
  /**
  
     * Logs a user in based on the provided request and response objects.
     *
     * This method verifies the user's credentials, generates a JWT token, and sets it as a cookie.
     * It also updates the user's public key in the database for future authentication.
     *
     * @param req - The Fastify request object containing user credentials.
     * @param res - The Fastify reply object used to send responses.
     *
     * @returns A promise that resolves to the Fastify reply object with the user's data.
     *
     * @example
     * // Successful login
     * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
     *   await login(req, res);
     *   console.log('User logged in:', res.body);
     * }
     *
     * @example
     * // Handling invalid credentials
     * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
     *   const response = await login(req, res);
     *   if (response.statusCode === 401) {
     *     console.log(response.message); // "Credenciais inválidas"
     *   }
     * }
     *
     * @example
     * // Handling login errors
     * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
     *   try {
     *     await login(req, res);
     *   } catch (error) {
     *     console.error('Login failed:', error);
     *     // Handle login errors
     *   }
     * }
  
     * Authenticates a user based on provided credentials.
     *
     * This asynchronous function processes a login request by validating the user's
     * identification and password. If the credentials are valid, it generates a JWT token,
     * sets it as a cookie in the response, and returns the user data.
     *
     * @param {FastifyRequest} req - The request object containing user credentials in the body.
     * @param {FastifyReply} res - The response object used to send back the result of the login attempt.
     * @returns {Promise<void>} A promise that resolves when the response has been sent.
     *
     * @throws {Error} Throws an error if the login process encounters an issue, which is handled
     *                 by the ErrorsHandler.
     *
     * @example
     * // Example usage of the login function
     * app.post('/login', async (req, res) => {
     *   await login(req, res);
     * });
  
     */
  login = async (req, res) => {
    try {
      const { identification, password } = userValidations.getForLogin.parse(
        req.body
      );
      const user = await userModel.getByEmail(identification);
      if (!user || !await hashService.comparePassword(password, user.senha)) {
        throw new AppError("Credenciais inv\xE1lidas", 401);
      }
      const payload = { id: user.id, name: user.nome };
      const token = req.jwt.sign(payload);
      res.setCookie("access_token", token, {
        path: "/",
        httpOnly: true,
        secure: process.env.NODE_ENV === "production",
        sameSite: "strict",
        maxAge: Number(process.env.JWT_EXPIRES_IN)
      });
      const { senha: pwd, ...userData } = user;
      console.log(userData);
      return res.send(userData);
    } catch (error) {
      console.log(error);
      ErrorsHandler.handle(error, res);
    }
  };
  getSessionData = async (req, res) => {
    try {
      const token = req.cookies.access_token;
      if (!token) {
        throw new AppError("Inicie sess\xE3o", 401);
      }
      const decoded = req.jwt.decode(token);
      if (!decoded) {
        res.clearCookie("access_token", { path: "/" });
        throw new AppError("Sess\xE3o inv\xE1lida", 401);
      }
      const user = req.jwt.verify(token);
      const userData = await userModel.getById(user.id);
      if (!userData) {
        throw new AppError("Usu\xE1rio n\xE3o encontrado", 404);
      }
      const { senha: pwd, ...dataToSend } = userData;
      return res.send(dataToSend);
    } catch (err) {
      console.error("Erro na autentica\xE7\xE3o:", err);
      res.clearCookie("access_token", { path: "/" });
      throw new AppError("Sess\xE3o inv\xE1lida", 401);
    }
  };
  /**
   * Logs a user out based on the provided request and response objects.
   *
   * This method clears the user's access token cookie and updates the user's public key in the database.
   *
   * @param req - The Fastify request object containing the user's data.
   * @param res - The Fastify reply object used to send responses.
   *
   * @returns A promise that resolves to the Fastify reply object with a success message.
   *
   * @example
   * // Successful logout
   * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
   *   await logout(req, res);
   *   console.log('User logged out:', res.body);
   * }
   *
   * @example
   * // Handling logout errors
   * async function handleRequest(req: FastifyRequest, res: FastifyReply) {
   *   try {
   *     await logout(req, res);
   *   } catch (error) {
   *     console.error('Logout failed:', error);
   *     // Handle logout errors
   *   }
   * }
   */
  logout = async (req, res) => {
    res.clearCookie("access_token", { path: "/" });
    return res.send({ message: "Logout realizado com sucesso!" });
  };
};
var authService = new AuthService();

// src/server/routes/base/index.ts
var BaseRoute = class {
  static async handle(app2, service, routeBaseName) {
    app2.get(`/${routeBaseName}/simple`, service.getAllWithoutIncludes.bind(service));
    app2.get(`/${routeBaseName}`, service.getAll.bind(service));
    app2.get(`/${routeBaseName}/:id`, service.getById.bind(service));
    app2.post(`/${routeBaseName}`, service.create.bind(service));
    app2.put(`/${routeBaseName}/:id`, service.update.bind(service));
    app2.delete(`/${routeBaseName}/:id`, service.delete.bind(service));
  }
  static async relation(app2, service, routeBaseName) {
    app2.post(`/${routeBaseName}`, service.create);
    app2.get(`/${routeBaseName}/disciplina`, service.getDisciplineClass);
  }
  static async import(app2, service, routeBaseName) {
  }
  static async statiscs(app2, service, routeBaseName) {
    app2.get(`/${routeBaseName}/estatistica`, service.getAll);
  }
};

// src/modules/models/benefit.ts
var benefitInclude = {
  categoria: true,
  referencias: true
};
var BenefitModel = class extends BaseModel {
  model = prisma_default.beneficio;
  include = benefitInclude;
  orderBy = {
    created_at: "desc"
  };
};
var benefitModel = new BenefitModel();

// src/modules/validations/benefit.ts
var import_zod5 = __toESM(require("zod"));
var BenefitValidation = class {
  getData = import_zod5.default.object({
    nome: nonEmptyString("O nome do benef\xEDcio \xE9 obrigat\xF3rio"),
    descricao: nonEmptyString("A descri\xE7\xE3o do benef\xEDcio \xE9 obrigat\xF3ria"),
    pontos: import_zod5.default.number().int().positive("A quantidade de pontos necess\xE1rios deve ser um n\xFAmero positivo"),
    id_categoria: nonEmptyString("A categoria do benef\xEDcio \xE9 obrigat\xF3ria")
  });
  getDataToUpdate = this.getData.partial();
};
var benefitValidations = new BenefitValidation();

// src/modules/validations/params.ts
var import_zod6 = require("zod");
var ParamsValidations = class {
  static getId = import_zod6.z.object({
    id: import_zod6.z.string()
  });
  static getPersonId = import_zod6.z.object({
    id_pessoa: import_zod6.z.string()
  });
};

// src/modules/validations/query.ts
var import_zod7 = require("zod");
var QueryValidations = class {
  static getData = import_zod7.z.object({
    page: import_zod7.z.string().optional(),
    limit: import_zod7.z.string().optional(),
    filter: import_zod7.z.string().optional()
  });
};

// src/modules/services/base/index.ts
var BaseService = class {
  createValidationSchema;
  updateValidationSchema;
  queryValidation = QueryValidations.getData;
  create = async (req, res) => {
    try {
      const data = this.createValidationSchema?.parse(req.body);
      const item = await this.model.create(data);
      return res.status(201).send(item);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
  getAllWithoutIncludes = async (req, res) => {
    try {
      const { filter, limit, page, ...rest } = this.queryValidation.parse(
        req.query
      );
      let take = void 0;
      let skip = void 0;
      if (page && limit) {
        take = parseInt(limit);
        skip = take * (parseInt(page) - 1);
      }
      const items = await this.model.getAllWithoutIncludes({
        take,
        skip,
        filter,
        ...rest
      });
      return res.send(items);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
  getAll = async (req, res) => {
    try {
      const { limit, page, filter, ...rest } = this.queryValidation.parse(
        req.query
      );
      console.log({ limit, page, filter, ...rest });
      let take = void 0;
      let skip = void 0;
      if (page && limit) {
        take = parseInt(limit);
        skip = take * (parseInt(page) - 1);
      }
      const items = await this.model.getAll({ take, skip, filter, ...rest });
      const totalItems = await this.model.count();
      const totalPages = take ? Math.ceil(totalItems / take) : 1;
      const currentPage = page ? parseInt(page) : 1;
      const data = {
        data: items,
        info: {
          totalItems,
          totalPages,
          currentPage
        }
      };
      return res.send(data);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
  getById = async (req, res) => {
    try {
      const { id } = ParamsValidations.getId.parse(req.params);
      const item = await this.model.getById(id);
      return res.send(item);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
  update = async (req, res) => {
    console.log("UPDATE", req.body);
    try {
      const { id } = ParamsValidations.getId.parse(req.params);
      const dataToUpdate = this.updateValidationSchema?.parse(req.body);
      const updatedItem = await this.model.update(id, dataToUpdate);
      return res.send(updatedItem);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
  delete = async (req, res) => {
    try {
      const { id } = ParamsValidations.getId.parse(req.params);
      const deletedItem = await this.model.delete(id);
      return res.send(deletedItem);
    } catch (error) {
      ErrorsHandler.handle(error, res);
    }
  };
};

// src/modules/services/benefit.ts
var BenefitService = class extends BaseService {
  model = benefitModel;
  createValidationSchema = benefitValidations.getData;
  updateValidationSchema = benefitValidations.getDataToUpdate;
};
var benefitService = new BenefitService();

// src/server/routes/private/benefit.routes.ts
async function benefits(app2) {
  await BaseRoute.handle(app2, benefitService, "benefits");
}

// src/modules/models/category.ts
var categoryInclude = {
  beneficios: true
};
var CategoryModel = class extends BaseModel {
  model = prisma_default.categoria;
  include = categoryInclude;
};
var categoryModel = new CategoryModel();

// src/modules/validations/category.ts
var import_zod8 = __toESM(require("zod"));
var CategoryValidation = class {
  getData = import_zod8.default.object({
    nome: nonEmptyString("O nome da categoria deve ter no m\xEDnimo 3 caracteres"),
    descricao: nonEmptyString("A descri\xE7\xE3o da categoria \xE9 obrigat\xF3ria")
  });
  getDataToUpdate = this.getData.partial();
};
var categoryValidations = new CategoryValidation();

// src/modules/services/category.ts
var CategoryService = class extends BaseService {
  model = categoryModel;
  createValidationSchema = categoryValidations.getData;
  updateValidationSchema = categoryValidations.getDataToUpdate;
};
var categoryService = new CategoryService();

// src/server/routes/private/category.routes.ts
async function categories(app2) {
  await BaseRoute.handle(app2, categoryService, "categories");
}

// src/modules/models/card.ts
var CardModel = class extends BaseModel {
  model = prisma_default.cartao;
  include = {};
};
var cardModel = new CardModel();

// src/modules/validations/card.ts
var import_zod9 = __toESM(require("zod"));
var CardValidation = class {
  getData = import_zod9.default.object({
    numero: nonEmptyString("O c\xF3digo do cart\xE3o \xE9 obrigat\xF3rio")
  });
  getDataToUpdate = this.getData.partial();
};
var cardValidations = new CardValidation();

// src/modules/services/card.ts
var CardService = class extends BaseService {
  model = cardModel;
  createValidationSchema = cardValidations.getData;
  updateValidationSchema = cardValidations.getDataToUpdate;
};
var cardService = new CardService();

// src/server/routes/private/card.routes.ts
async function cards(app2) {
  await BaseRoute.handle(app2, cardService, "/cards");
}

// src/modules/services/user.ts
var UserService = class extends BaseService {
  model = userModel;
  createValidationSchema = userValidations.getData;
  updateValidationSchema = userValidations.getDataToUpdate;
  create = async (req, res) => {
    const userData = userValidations.getData.parse(req.body);
    const hashedPassword = await hashService.hashPassword(userData.senha);
    if (await userModel.getByEmail(userData.email)) {
      throw new AppError("Email j\xE1 em uso na plataforma.", 400);
    }
    const user = await userModel.create({
      ...userData,
      email_recuperacao: userData.email_recuperacao ?? userData.email,
      senha: hashedPassword
    });
    return res.send(user);
  };
  update = async (req, res) => {
    const { id } = ParamsValidations.getId.parse(req.params);
    const dataToUpdate = userValidations.getDataToUpdate.parse(req.body);
    if (dataToUpdate.senha) {
      dataToUpdate.senha = await hashService.hashPassword(dataToUpdate?.senha);
    }
    const updatedUser = await userModel.update(id, dataToUpdate);
    return res.send(updatedUser);
  };
};
var userService = new UserService();

// src/server/routes/private/user.routes.ts
async function users(app2) {
  await BaseRoute.handle(app2, userService, "users");
  app2.get("/users/session", authService.getSessionData);
}

// src/modules/models/reference.ts
var referenceInclude = {
  beneficio: true
};
var ReferenceModel = class extends BaseModel {
  model = prisma_default.referencia;
  include = referenceInclude;
  getUnusedReferences = async (benefit) => {
    return this.model.findFirst({
      where: {
        id_beneficio: benefit,
        usado: false
      },
      include: this.include
    });
  };
};
var referenceModel = new ReferenceModel();

// src/modules/validations/reference.ts
var import_zod10 = __toESM(require("zod"));
var ReferenceValidation = class {
  getData = import_zod10.default.object({
    codigo: import_zod10.default.coerce.string({
      required_error: "O c\xF3digo da refer\xEAncia \xE9 obrigat\xF3rio"
    }),
    usado: import_zod10.default.boolean().optional(),
    id_beneficio: nonEmptyString("O benef\xEDcio \xE9 obrigat\xF3rio")
  });
  getDataToUpdate = this.getData.partial();
};
var referenceValidations = new ReferenceValidation();

// src/modules/services/reference.ts
var ReferenceService = class extends BaseService {
  model = referenceModel;
  createValidationSchema = referenceValidations.getData;
  updateValidationSchema = referenceValidations.getDataToUpdate;
};
var referenceService = new ReferenceService();

// src/server/routes/private/reference.routes.ts
async function references(app2) {
  await BaseRoute.handle(app2, referenceService, "references");
}

// src/modules/models/exchange.ts
var ExchangeModel = class extends BaseModel {
  model = prisma_default.troca;
  include = {};
};
var exchangeModel = new ExchangeModel();

// src/modules/validations/exchange.ts
var import_zod11 = __toESM(require("zod"));
var ExchangeValidation = class {
  getData = import_zod11.default.object({
    telefone: import_zod11.default.preprocess(
      (val) => typeof val === "string" && val.trim() === "" ? void 0 : val,
      import_zod11.default.string({
        invalid_type_error: "Telefone deve ser uma string"
      }).optional().refine(
        (value) => value === void 0 || angolanPhoneSchema.safeParse(value).success,
        { message: "Telefone inv\xE1lido" }
      )
    ),
    email: import_zod11.default.preprocess(
      (val) => typeof val === "string" && val.trim() === "" ? void 0 : val,
      import_zod11.default.string().email("Email inv\xE1lido").optional()
    ),
    id_usuario: import_zod11.default.string(),
    id_beneficio: import_zod11.default.string()
  });
};
var exchangeValidations = new ExchangeValidation();

// src/modules/lib/axios.ts
var import_axios = __toESM(require("axios"));
var api = import_axios.default.create();

// src/modules/services/sms.ts
var sendSms = async (phone, message) => {
  try {
    await api.post("https://www.telcosms.co.ao/api/v2/send_message", {
      message: {
        api_key_app: process.env.SMS_API_KEY,
        phone_number: phone,
        message_body: message
      }
    });
    return true;
  } catch {
    return false;
  }
};

// src/modules/lib/mail.ts
var import_nodemailer = __toESM(require("nodemailer"));
var MailProvider = class {
  async send(to, html) {
    const isEmail = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (isEmail.test(to)) {
      const transporter = import_nodemailer.default.createTransport({
        host: "ws1.angoweb.net",
        port: 465,
        secure: true,
        auth: {
          user: process.env.EMAIL,
          pass: process.env.EMAIL_PASSWORD
        }
      });
      const mailOptions = {
        from: process.env.EMAIL,
        to,
        subject: "Tuassakidila",
        html
      };
      try {
        await transporter.sendMail(mailOptions);
      } catch (error) {
        throw new Error(`${error}`);
      }
    } else {
      throw new Error("Forne\xE7a um email v\xE1lido");
    }
  }
};
var mailProvider = new MailProvider();

// src/modules/templates/email/exchanges.ts
var emailCompleteExchangeTemplate = (data) => {
  return `
        <html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirma\xE7\xE3o de Troca</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 90%;
        }
        .logo {
            display: block;
            margin: 0 auto 20px; 
            max-width: 250px;  
            max-height: 250px; 
        }
        h2 {
            color: #4a6350;
            font-size: 22px;
            margin-bottom: 10px;
            text-align: center;
        }
        h3 {
            color: #4a6350;
            font-size: 18px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        p, ul {
            font-size: 15px;
            color: #555;
            line-height: 1.6;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        ul li {
            margin-bottom: 8px;
        }
        ul li strong {
            color: #4a6350;
        }
        .code {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            background-color: #f4f4f4;
            padding: 12px;
            border: 1px dashed #c4d8c8;
            border-radius: 5px;
            text-align: center;
            margin-top: 10px;
            display: inline-block;
        }
        .footer {
            font-size: 14px;
            color: #777;
            text-align: center;
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="https://tuassakidila.ipil.ao/pages/assets/img/logo-tuassakidila.png" alt="Logo da Empresa" class="logo"> 
        <h2>Confirma\xE7\xE3o de Troca \u2013 Seu C\xF3digo de Recarga</h2>
        <p>Ol\xE1 ${data.name},</p>
        
        <p>Agradecemos por utilizar nossos servi\xE7os de troca. Estamos felizes em confirmar que sua solicita\xE7\xE3o foi processada com sucesso.</p>

        <h3>Detalhes da Troca:</h3>
        <ul>
            <li><strong>Categoria:</strong> ${data.category}</li>
            <li><strong>Servi\xE7o:</strong> ${data.benefit}</li>
            <li><strong>Descri\xE7\xE3o:</strong> ${data.description}</li>
            <li><strong>Valor da Troca:</strong> ${data.value} Pontos</li>
            <li><strong>Data da Troca:</strong> ${data.created_at}</li>
        </ul>

        <h3>Seu C\xF3digo de Recarga:</h3>
        <p class="code">${data.code}</p>

        <p>Use este c\xF3digo para ativar sua recarga e desfrutar dos nossos servi\xE7os. Caso tenha alguma d\xFAvida ou precise de assist\xEAncia, nossa equipe de suporte est\xE1 \xE0 disposi\xE7\xE3o para ajudar.</p>

        <p>Agradecemos pela sua confian\xE7a e esperamos v\xEA-lo novamente em breve!</p>

        <div class="footer">
            <p>Atenciosamente,<br>
            Tuassakidila | IPIL <br>
            tuassakidila.ipil.ao</p>
        </div>
    </div>
</body>
</html>
    `;
};
var emailAddedNotificationTemplate = (email, name) => {
  return `
          <div style="max-width: 600px; margin: 0 auto; font-family: Arial, sans-serif; color: #333;">
              <h1 style="text-align: center; color: #D96F32;">Portal Ipil</h1>
              <h2 style="text-align: center;">E-mail Adicionado \xE0 Conta</h2>
              <p style="font-size: 16px; text-align: center;">
                  Informamos que o seguinte e-mail foi adicionado \xE0 sua conta no <strong>Portal do Ipil</strong>:
              </p>
              <div style="
                  background-color: #f4f4f4;
                  padding: 15px;
                  border-radius: 5px;
                  text-align: center;
                  font-size: 18px;
                  margin: 20px 0;
              ">
                  <p><strong>E-mail:</strong> ${email}</p>
                  <p><strong>Nome do propriet\xE1rio da conta:</strong> ${name}</p>
                  <p><strong>Data:</strong> ${(/* @__PURE__ */ new Date()).toLocaleDateString()}</p>
              </div>
              <p style="font-size: 14px; color: #777; text-align: center;">
                  Caso voc\xEA n\xE3o tenha realizado esta a\xE7\xE3o, entre em contato com o suporte imediatamente.
              </p>
              <p style="font-size: 14px; text-align: center; margin-top: 20px; color: #555;">
                  Obrigado por utilizar o Portal do Ipil.
              </p>
          </div>
      `;
};

// src/modules/services/mail.ts
var MailService = class {
  sendCompleteExchange = async (to, data) => {
    await mailProvider.send(to, emailCompleteExchangeTemplate(data));
  };
  notifyAddedEmail = async (to, { email, name }) => {
    await mailProvider.send(to, emailAddedNotificationTemplate(email, name));
  };
};
var mailService = new MailService();

// src/modules/templates/sms/sms.ts
var smsCompleteExchange = (codigo) => {
  return `Troca realizada com sucesso, o c\xF3digo \xE9 ${codigo}.`;
};

// src/modules/services/exchange.ts
var ExchangeService = class extends BaseService {
  model = exchangeModel;
  create = async (req, res) => {
    const data = exchangeValidations.getData.parse(req.body);
    const reference = await referenceModel.getUnusedReferences(
      data.id_beneficio
    );
    if (!reference) {
      throw new Error("N\xE3o h\xE1 refer\xEAncias dispon\xEDveis para este benef\xEDcio.");
    }
    const user = await userModel.getById(data.id_usuario);
    const { id_beneficio, ...exchangeData } = data;
    const benefit = await benefitModel.getById(id_beneficio);
    const category = await categoryModel.getById(benefit?.id_categoria);
    const operation = await prisma_default.$transaction(async (tx) => {
      const exchange = await tx.troca.create({
        data: {
          ...exchangeData,
          id_referencia: reference.id
        }
      });
      await tx.referencia.update({
        where: { id: reference.id },
        data: { usado: true }
      });
      return exchange;
    });
    const createdAt = (/* @__PURE__ */ new Date()).toISOString();
    if (data.telefone)
      await sendSms(data.telefone, smsCompleteExchange(reference.codigo));
    if (data.email) {
      await mailService.sendCompleteExchange(data.email, {
        name: user?.nome,
        code: reference.codigo,
        created_at: createdAt,
        value: benefit?.pontos.toString(),
        benefit: benefit?.nome,
        category: category?.nome,
        description: benefit?.descricao
      });
    }
    return res.send(operation);
  };
};
var exchangeService = new ExchangeService();

// src/server/routes/private/exchange.routes.ts
async function exchanges(app2) {
  await BaseRoute.handle(app2, exchangeService, "exchanges");
}

// src/server/routes/private/index.ts
async function privateRoutes(app2) {
  app2.register(async (privateApp) => {
    privateApp.addHook("preHandler", authService.authenticate);
    privateApp.delete("/logout", authService.logout);
    await benefits(privateApp);
    await categories(privateApp);
    await cards(privateApp);
    await users(privateApp);
    await references(privateApp);
    await exchanges(privateApp);
  });
}

// src/server/routes/public/index.ts
async function publicRoutes(app2) {
  app2.post("/login", authService.login);
}

// src/server/index.ts
var import_cookie = __toESM(require("@fastify/cookie"));
var import_dayjs = __toESM(require("dayjs"));
var import_helmet = __toESM(require("@fastify/helmet"));
var import_pt = require("dayjs/locale/pt");
import_dayjs.default.locale("pt");
var app = (0, import_fastify.default)({
  logger: true
});
var port = Number(process.env.PORT) || 5e3;
var listeners = ["SIGINT", "SIGTERM"];
listeners.forEach((signal) => {
  process.on(signal, async () => {
    await app.close();
    process.exit(0);
  });
});
var start = async () => {
  try {
    app.setErrorHandler((error, _, reply) => {
      ErrorsHandler.handle(error, reply);
    });
    await app.register(import_cors.default, {
      origin: process.env.CROSS_ORIGIN,
      credentials: true
    });
    await app.register(import_jwt.default, {
      secret: process.env.JWT_SECRET || "secret",
      sign: {
        expiresIn: Number(process.env.JWT_EXPIRES_IN)
      }
    });
    app.addHook("preHandler", (req, res, next) => {
      req.jwt = app.jwt;
      return next();
    });
    app.addHook("onClose", async () => {
      await prisma_default.$disconnect();
    });
    app.register(import_cookie.default, {
      secret: process.env.COOKIE_SECRET,
      hook: "preHandler",
      parseOptions: {
        secure: process.env.NODE_ENV === "production",
        sameSite: "strict",
        httpOnly: true
      }
    });
    await app.register(import_multipart.default, {
      limits: {
        fieldNameSize: 100,
        fieldSize: 1024 * 1024 * 5,
        fields: 1e3,
        fileSize: 1024 * 1024 * 50,
        files: 70,
        headerPairs: 2e3,
        parts: 1e3
      },
      attachFieldsToBody: true
    });
    await app.register(import_helmet.default);
    await app.register(privateRoutes);
    await app.register(publicRoutes);
    await app.listen({ port, host: "0.0.0.0" });
  } catch (err) {
    console.log(err);
    app.log.error(err);
    process.exit(1);
  }
};
start();
