
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Usuario
 * 
 */
export type Usuario = $Result.DefaultSelection<Prisma.$UsuarioPayload>
/**
 * Model Cartao
 * 
 */
export type Cartao = $Result.DefaultSelection<Prisma.$CartaoPayload>
/**
 * Model CartaoUsuario
 * 
 */
export type CartaoUsuario = $Result.DefaultSelection<Prisma.$CartaoUsuarioPayload>
/**
 * Model Referencia
 * 
 */
export type Referencia = $Result.DefaultSelection<Prisma.$ReferenciaPayload>
/**
 * Model Beneficio
 * 
 */
export type Beneficio = $Result.DefaultSelection<Prisma.$BeneficioPayload>
/**
 * Model Categoria
 * 
 */
export type Categoria = $Result.DefaultSelection<Prisma.$CategoriaPayload>
/**
 * Model Troca
 * 
 */
export type Troca = $Result.DefaultSelection<Prisma.$TrocaPayload>

/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Usuarios
 * const usuarios = await prisma.usuario.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Usuarios
   * const usuarios = await prisma.usuario.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs>

      /**
   * `prisma.usuario`: Exposes CRUD operations for the **Usuario** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Usuarios
    * const usuarios = await prisma.usuario.findMany()
    * ```
    */
  get usuario(): Prisma.UsuarioDelegate<ExtArgs>;

  /**
   * `prisma.cartao`: Exposes CRUD operations for the **Cartao** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Cartaos
    * const cartaos = await prisma.cartao.findMany()
    * ```
    */
  get cartao(): Prisma.CartaoDelegate<ExtArgs>;

  /**
   * `prisma.cartaoUsuario`: Exposes CRUD operations for the **CartaoUsuario** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CartaoUsuarios
    * const cartaoUsuarios = await prisma.cartaoUsuario.findMany()
    * ```
    */
  get cartaoUsuario(): Prisma.CartaoUsuarioDelegate<ExtArgs>;

  /**
   * `prisma.referencia`: Exposes CRUD operations for the **Referencia** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Referencias
    * const referencias = await prisma.referencia.findMany()
    * ```
    */
  get referencia(): Prisma.ReferenciaDelegate<ExtArgs>;

  /**
   * `prisma.beneficio`: Exposes CRUD operations for the **Beneficio** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Beneficios
    * const beneficios = await prisma.beneficio.findMany()
    * ```
    */
  get beneficio(): Prisma.BeneficioDelegate<ExtArgs>;

  /**
   * `prisma.categoria`: Exposes CRUD operations for the **Categoria** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Categorias
    * const categorias = await prisma.categoria.findMany()
    * ```
    */
  get categoria(): Prisma.CategoriaDelegate<ExtArgs>;

  /**
   * `prisma.troca`: Exposes CRUD operations for the **Troca** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Trocas
    * const trocas = await prisma.troca.findMany()
    * ```
    */
  get troca(): Prisma.TrocaDelegate<ExtArgs>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.1.0
   * Query Engine version: 11f085a2012c0f4778414c8db2651556ee0ef959
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Usuario: 'Usuario',
    Cartao: 'Cartao',
    CartaoUsuario: 'CartaoUsuario',
    Referencia: 'Referencia',
    Beneficio: 'Beneficio',
    Categoria: 'Categoria',
    Troca: 'Troca'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "usuario" | "cartao" | "cartaoUsuario" | "referencia" | "beneficio" | "categoria" | "troca"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      Usuario: {
        payload: Prisma.$UsuarioPayload<ExtArgs>
        fields: Prisma.UsuarioFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UsuarioFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UsuarioFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          findFirst: {
            args: Prisma.UsuarioFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UsuarioFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          findMany: {
            args: Prisma.UsuarioFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>[]
          }
          create: {
            args: Prisma.UsuarioCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          createMany: {
            args: Prisma.UsuarioCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UsuarioDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          update: {
            args: Prisma.UsuarioUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          deleteMany: {
            args: Prisma.UsuarioDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UsuarioUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UsuarioUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UsuarioPayload>
          }
          aggregate: {
            args: Prisma.UsuarioAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUsuario>
          }
          groupBy: {
            args: Prisma.UsuarioGroupByArgs<ExtArgs>
            result: $Utils.Optional<UsuarioGroupByOutputType>[]
          }
          count: {
            args: Prisma.UsuarioCountArgs<ExtArgs>
            result: $Utils.Optional<UsuarioCountAggregateOutputType> | number
          }
        }
      }
      Cartao: {
        payload: Prisma.$CartaoPayload<ExtArgs>
        fields: Prisma.CartaoFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CartaoFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CartaoFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          findFirst: {
            args: Prisma.CartaoFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CartaoFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          findMany: {
            args: Prisma.CartaoFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>[]
          }
          create: {
            args: Prisma.CartaoCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          createMany: {
            args: Prisma.CartaoCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.CartaoDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          update: {
            args: Prisma.CartaoUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          deleteMany: {
            args: Prisma.CartaoDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CartaoUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.CartaoUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoPayload>
          }
          aggregate: {
            args: Prisma.CartaoAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCartao>
          }
          groupBy: {
            args: Prisma.CartaoGroupByArgs<ExtArgs>
            result: $Utils.Optional<CartaoGroupByOutputType>[]
          }
          count: {
            args: Prisma.CartaoCountArgs<ExtArgs>
            result: $Utils.Optional<CartaoCountAggregateOutputType> | number
          }
        }
      }
      CartaoUsuario: {
        payload: Prisma.$CartaoUsuarioPayload<ExtArgs>
        fields: Prisma.CartaoUsuarioFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CartaoUsuarioFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CartaoUsuarioFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          findFirst: {
            args: Prisma.CartaoUsuarioFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CartaoUsuarioFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          findMany: {
            args: Prisma.CartaoUsuarioFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>[]
          }
          create: {
            args: Prisma.CartaoUsuarioCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          createMany: {
            args: Prisma.CartaoUsuarioCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.CartaoUsuarioDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          update: {
            args: Prisma.CartaoUsuarioUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          deleteMany: {
            args: Prisma.CartaoUsuarioDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CartaoUsuarioUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.CartaoUsuarioUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CartaoUsuarioPayload>
          }
          aggregate: {
            args: Prisma.CartaoUsuarioAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCartaoUsuario>
          }
          groupBy: {
            args: Prisma.CartaoUsuarioGroupByArgs<ExtArgs>
            result: $Utils.Optional<CartaoUsuarioGroupByOutputType>[]
          }
          count: {
            args: Prisma.CartaoUsuarioCountArgs<ExtArgs>
            result: $Utils.Optional<CartaoUsuarioCountAggregateOutputType> | number
          }
        }
      }
      Referencia: {
        payload: Prisma.$ReferenciaPayload<ExtArgs>
        fields: Prisma.ReferenciaFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ReferenciaFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ReferenciaFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          findFirst: {
            args: Prisma.ReferenciaFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ReferenciaFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          findMany: {
            args: Prisma.ReferenciaFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>[]
          }
          create: {
            args: Prisma.ReferenciaCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          createMany: {
            args: Prisma.ReferenciaCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ReferenciaDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          update: {
            args: Prisma.ReferenciaUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          deleteMany: {
            args: Prisma.ReferenciaDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ReferenciaUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ReferenciaUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferenciaPayload>
          }
          aggregate: {
            args: Prisma.ReferenciaAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateReferencia>
          }
          groupBy: {
            args: Prisma.ReferenciaGroupByArgs<ExtArgs>
            result: $Utils.Optional<ReferenciaGroupByOutputType>[]
          }
          count: {
            args: Prisma.ReferenciaCountArgs<ExtArgs>
            result: $Utils.Optional<ReferenciaCountAggregateOutputType> | number
          }
        }
      }
      Beneficio: {
        payload: Prisma.$BeneficioPayload<ExtArgs>
        fields: Prisma.BeneficioFieldRefs
        operations: {
          findUnique: {
            args: Prisma.BeneficioFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.BeneficioFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          findFirst: {
            args: Prisma.BeneficioFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.BeneficioFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          findMany: {
            args: Prisma.BeneficioFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>[]
          }
          create: {
            args: Prisma.BeneficioCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          createMany: {
            args: Prisma.BeneficioCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.BeneficioDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          update: {
            args: Prisma.BeneficioUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          deleteMany: {
            args: Prisma.BeneficioDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.BeneficioUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.BeneficioUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BeneficioPayload>
          }
          aggregate: {
            args: Prisma.BeneficioAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateBeneficio>
          }
          groupBy: {
            args: Prisma.BeneficioGroupByArgs<ExtArgs>
            result: $Utils.Optional<BeneficioGroupByOutputType>[]
          }
          count: {
            args: Prisma.BeneficioCountArgs<ExtArgs>
            result: $Utils.Optional<BeneficioCountAggregateOutputType> | number
          }
        }
      }
      Categoria: {
        payload: Prisma.$CategoriaPayload<ExtArgs>
        fields: Prisma.CategoriaFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoriaFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoriaFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          findFirst: {
            args: Prisma.CategoriaFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoriaFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          findMany: {
            args: Prisma.CategoriaFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>[]
          }
          create: {
            args: Prisma.CategoriaCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          createMany: {
            args: Prisma.CategoriaCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.CategoriaDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          update: {
            args: Prisma.CategoriaUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          deleteMany: {
            args: Prisma.CategoriaDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CategoriaUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.CategoriaUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoriaPayload>
          }
          aggregate: {
            args: Prisma.CategoriaAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCategoria>
          }
          groupBy: {
            args: Prisma.CategoriaGroupByArgs<ExtArgs>
            result: $Utils.Optional<CategoriaGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoriaCountArgs<ExtArgs>
            result: $Utils.Optional<CategoriaCountAggregateOutputType> | number
          }
        }
      }
      Troca: {
        payload: Prisma.$TrocaPayload<ExtArgs>
        fields: Prisma.TrocaFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TrocaFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TrocaFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          findFirst: {
            args: Prisma.TrocaFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TrocaFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          findMany: {
            args: Prisma.TrocaFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>[]
          }
          create: {
            args: Prisma.TrocaCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          createMany: {
            args: Prisma.TrocaCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.TrocaDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          update: {
            args: Prisma.TrocaUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          deleteMany: {
            args: Prisma.TrocaDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TrocaUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.TrocaUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrocaPayload>
          }
          aggregate: {
            args: Prisma.TrocaAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTroca>
          }
          groupBy: {
            args: Prisma.TrocaGroupByArgs<ExtArgs>
            result: $Utils.Optional<TrocaGroupByOutputType>[]
          }
          count: {
            args: Prisma.TrocaCountArgs<ExtArgs>
            result: $Utils.Optional<TrocaCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
  }


  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UsuarioCountOutputType
   */

  export type UsuarioCountOutputType = {
    trocas: number
  }

  export type UsuarioCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    trocas?: boolean | UsuarioCountOutputTypeCountTrocasArgs
  }

  // Custom InputTypes
  /**
   * UsuarioCountOutputType without action
   */
  export type UsuarioCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UsuarioCountOutputType
     */
    select?: UsuarioCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UsuarioCountOutputType without action
   */
  export type UsuarioCountOutputTypeCountTrocasArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TrocaWhereInput
  }


  /**
   * Count Type BeneficioCountOutputType
   */

  export type BeneficioCountOutputType = {
    referencias: number
  }

  export type BeneficioCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    referencias?: boolean | BeneficioCountOutputTypeCountReferenciasArgs
  }

  // Custom InputTypes
  /**
   * BeneficioCountOutputType without action
   */
  export type BeneficioCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the BeneficioCountOutputType
     */
    select?: BeneficioCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * BeneficioCountOutputType without action
   */
  export type BeneficioCountOutputTypeCountReferenciasArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferenciaWhereInput
  }


  /**
   * Count Type CategoriaCountOutputType
   */

  export type CategoriaCountOutputType = {
    beneficios: number
  }

  export type CategoriaCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    beneficios?: boolean | CategoriaCountOutputTypeCountBeneficiosArgs
  }

  // Custom InputTypes
  /**
   * CategoriaCountOutputType without action
   */
  export type CategoriaCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoriaCountOutputType
     */
    select?: CategoriaCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoriaCountOutputType without action
   */
  export type CategoriaCountOutputTypeCountBeneficiosArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BeneficioWhereInput
  }


  /**
   * Models
   */

  /**
   * Model Usuario
   */

  export type AggregateUsuario = {
    _count: UsuarioCountAggregateOutputType | null
    _avg: UsuarioAvgAggregateOutputType | null
    _sum: UsuarioSumAggregateOutputType | null
    _min: UsuarioMinAggregateOutputType | null
    _max: UsuarioMaxAggregateOutputType | null
  }

  export type UsuarioAvgAggregateOutputType = {
    pontos: number | null
  }

  export type UsuarioSumAggregateOutputType = {
    pontos: number | null
  }

  export type UsuarioMinAggregateOutputType = {
    id: string | null
    nome: string | null
    email: string | null
    email_recuperacao: string | null
    senha: string | null
    telefone: string | null
    pontos: number | null
    foto: string | null
    tipo: string | null
  }

  export type UsuarioMaxAggregateOutputType = {
    id: string | null
    nome: string | null
    email: string | null
    email_recuperacao: string | null
    senha: string | null
    telefone: string | null
    pontos: number | null
    foto: string | null
    tipo: string | null
  }

  export type UsuarioCountAggregateOutputType = {
    id: number
    nome: number
    email: number
    email_recuperacao: number
    senha: number
    telefone: number
    pontos: number
    foto: number
    tipo: number
    _all: number
  }


  export type UsuarioAvgAggregateInputType = {
    pontos?: true
  }

  export type UsuarioSumAggregateInputType = {
    pontos?: true
  }

  export type UsuarioMinAggregateInputType = {
    id?: true
    nome?: true
    email?: true
    email_recuperacao?: true
    senha?: true
    telefone?: true
    pontos?: true
    foto?: true
    tipo?: true
  }

  export type UsuarioMaxAggregateInputType = {
    id?: true
    nome?: true
    email?: true
    email_recuperacao?: true
    senha?: true
    telefone?: true
    pontos?: true
    foto?: true
    tipo?: true
  }

  export type UsuarioCountAggregateInputType = {
    id?: true
    nome?: true
    email?: true
    email_recuperacao?: true
    senha?: true
    telefone?: true
    pontos?: true
    foto?: true
    tipo?: true
    _all?: true
  }

  export type UsuarioAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Usuario to aggregate.
     */
    where?: UsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Usuarios to fetch.
     */
    orderBy?: UsuarioOrderByWithRelationInput | UsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Usuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Usuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Usuarios
    **/
    _count?: true | UsuarioCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UsuarioAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UsuarioSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UsuarioMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UsuarioMaxAggregateInputType
  }

  export type GetUsuarioAggregateType<T extends UsuarioAggregateArgs> = {
        [P in keyof T & keyof AggregateUsuario]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUsuario[P]>
      : GetScalarType<T[P], AggregateUsuario[P]>
  }




  export type UsuarioGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UsuarioWhereInput
    orderBy?: UsuarioOrderByWithAggregationInput | UsuarioOrderByWithAggregationInput[]
    by: UsuarioScalarFieldEnum[] | UsuarioScalarFieldEnum
    having?: UsuarioScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UsuarioCountAggregateInputType | true
    _avg?: UsuarioAvgAggregateInputType
    _sum?: UsuarioSumAggregateInputType
    _min?: UsuarioMinAggregateInputType
    _max?: UsuarioMaxAggregateInputType
  }

  export type UsuarioGroupByOutputType = {
    id: string
    nome: string
    email: string
    email_recuperacao: string | null
    senha: string
    telefone: string
    pontos: number
    foto: string | null
    tipo: string
    _count: UsuarioCountAggregateOutputType | null
    _avg: UsuarioAvgAggregateOutputType | null
    _sum: UsuarioSumAggregateOutputType | null
    _min: UsuarioMinAggregateOutputType | null
    _max: UsuarioMaxAggregateOutputType | null
  }

  type GetUsuarioGroupByPayload<T extends UsuarioGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UsuarioGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UsuarioGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UsuarioGroupByOutputType[P]>
            : GetScalarType<T[P], UsuarioGroupByOutputType[P]>
        }
      >
    >


  export type UsuarioSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    nome?: boolean
    email?: boolean
    email_recuperacao?: boolean
    senha?: boolean
    telefone?: boolean
    pontos?: boolean
    foto?: boolean
    tipo?: boolean
    trocas?: boolean | Usuario$trocasArgs<ExtArgs>
    cartao_usuario?: boolean | Usuario$cartao_usuarioArgs<ExtArgs>
    _count?: boolean | UsuarioCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["usuario"]>


  export type UsuarioSelectScalar = {
    id?: boolean
    nome?: boolean
    email?: boolean
    email_recuperacao?: boolean
    senha?: boolean
    telefone?: boolean
    pontos?: boolean
    foto?: boolean
    tipo?: boolean
  }

  export type UsuarioInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    trocas?: boolean | Usuario$trocasArgs<ExtArgs>
    cartao_usuario?: boolean | Usuario$cartao_usuarioArgs<ExtArgs>
    _count?: boolean | UsuarioCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $UsuarioPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Usuario"
    objects: {
      trocas: Prisma.$TrocaPayload<ExtArgs>[]
      cartao_usuario: Prisma.$CartaoUsuarioPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      nome: string
      email: string
      email_recuperacao: string | null
      senha: string
      telefone: string
      pontos: number
      foto: string | null
      tipo: string
    }, ExtArgs["result"]["usuario"]>
    composites: {}
  }

  type UsuarioGetPayload<S extends boolean | null | undefined | UsuarioDefaultArgs> = $Result.GetResult<Prisma.$UsuarioPayload, S>

  type UsuarioCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UsuarioFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UsuarioCountAggregateInputType | true
    }

  export interface UsuarioDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Usuario'], meta: { name: 'Usuario' } }
    /**
     * Find zero or one Usuario that matches the filter.
     * @param {UsuarioFindUniqueArgs} args - Arguments to find a Usuario
     * @example
     * // Get one Usuario
     * const usuario = await prisma.usuario.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UsuarioFindUniqueArgs>(args: SelectSubset<T, UsuarioFindUniqueArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Usuario that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UsuarioFindUniqueOrThrowArgs} args - Arguments to find a Usuario
     * @example
     * // Get one Usuario
     * const usuario = await prisma.usuario.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UsuarioFindUniqueOrThrowArgs>(args: SelectSubset<T, UsuarioFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Usuario that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioFindFirstArgs} args - Arguments to find a Usuario
     * @example
     * // Get one Usuario
     * const usuario = await prisma.usuario.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UsuarioFindFirstArgs>(args?: SelectSubset<T, UsuarioFindFirstArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Usuario that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioFindFirstOrThrowArgs} args - Arguments to find a Usuario
     * @example
     * // Get one Usuario
     * const usuario = await prisma.usuario.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UsuarioFindFirstOrThrowArgs>(args?: SelectSubset<T, UsuarioFindFirstOrThrowArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Usuarios that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Usuarios
     * const usuarios = await prisma.usuario.findMany()
     * 
     * // Get first 10 Usuarios
     * const usuarios = await prisma.usuario.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const usuarioWithIdOnly = await prisma.usuario.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UsuarioFindManyArgs>(args?: SelectSubset<T, UsuarioFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Usuario.
     * @param {UsuarioCreateArgs} args - Arguments to create a Usuario.
     * @example
     * // Create one Usuario
     * const Usuario = await prisma.usuario.create({
     *   data: {
     *     // ... data to create a Usuario
     *   }
     * })
     * 
     */
    create<T extends UsuarioCreateArgs>(args: SelectSubset<T, UsuarioCreateArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Usuarios.
     * @param {UsuarioCreateManyArgs} args - Arguments to create many Usuarios.
     * @example
     * // Create many Usuarios
     * const usuario = await prisma.usuario.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UsuarioCreateManyArgs>(args?: SelectSubset<T, UsuarioCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Usuario.
     * @param {UsuarioDeleteArgs} args - Arguments to delete one Usuario.
     * @example
     * // Delete one Usuario
     * const Usuario = await prisma.usuario.delete({
     *   where: {
     *     // ... filter to delete one Usuario
     *   }
     * })
     * 
     */
    delete<T extends UsuarioDeleteArgs>(args: SelectSubset<T, UsuarioDeleteArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Usuario.
     * @param {UsuarioUpdateArgs} args - Arguments to update one Usuario.
     * @example
     * // Update one Usuario
     * const usuario = await prisma.usuario.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UsuarioUpdateArgs>(args: SelectSubset<T, UsuarioUpdateArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Usuarios.
     * @param {UsuarioDeleteManyArgs} args - Arguments to filter Usuarios to delete.
     * @example
     * // Delete a few Usuarios
     * const { count } = await prisma.usuario.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UsuarioDeleteManyArgs>(args?: SelectSubset<T, UsuarioDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Usuarios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Usuarios
     * const usuario = await prisma.usuario.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UsuarioUpdateManyArgs>(args: SelectSubset<T, UsuarioUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Usuario.
     * @param {UsuarioUpsertArgs} args - Arguments to update or create a Usuario.
     * @example
     * // Update or create a Usuario
     * const usuario = await prisma.usuario.upsert({
     *   create: {
     *     // ... data to create a Usuario
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Usuario we want to update
     *   }
     * })
     */
    upsert<T extends UsuarioUpsertArgs>(args: SelectSubset<T, UsuarioUpsertArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Usuarios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioCountArgs} args - Arguments to filter Usuarios to count.
     * @example
     * // Count the number of Usuarios
     * const count = await prisma.usuario.count({
     *   where: {
     *     // ... the filter for the Usuarios we want to count
     *   }
     * })
    **/
    count<T extends UsuarioCountArgs>(
      args?: Subset<T, UsuarioCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UsuarioCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Usuario.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UsuarioAggregateArgs>(args: Subset<T, UsuarioAggregateArgs>): Prisma.PrismaPromise<GetUsuarioAggregateType<T>>

    /**
     * Group by Usuario.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UsuarioGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UsuarioGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UsuarioGroupByArgs['orderBy'] }
        : { orderBy?: UsuarioGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UsuarioGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUsuarioGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Usuario model
   */
  readonly fields: UsuarioFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Usuario.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UsuarioClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    trocas<T extends Usuario$trocasArgs<ExtArgs> = {}>(args?: Subset<T, Usuario$trocasArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findMany"> | Null>
    cartao_usuario<T extends Usuario$cartao_usuarioArgs<ExtArgs> = {}>(args?: Subset<T, Usuario$cartao_usuarioArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Usuario model
   */ 
  interface UsuarioFieldRefs {
    readonly id: FieldRef<"Usuario", 'String'>
    readonly nome: FieldRef<"Usuario", 'String'>
    readonly email: FieldRef<"Usuario", 'String'>
    readonly email_recuperacao: FieldRef<"Usuario", 'String'>
    readonly senha: FieldRef<"Usuario", 'String'>
    readonly telefone: FieldRef<"Usuario", 'String'>
    readonly pontos: FieldRef<"Usuario", 'Int'>
    readonly foto: FieldRef<"Usuario", 'String'>
    readonly tipo: FieldRef<"Usuario", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Usuario findUnique
   */
  export type UsuarioFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter, which Usuario to fetch.
     */
    where: UsuarioWhereUniqueInput
  }

  /**
   * Usuario findUniqueOrThrow
   */
  export type UsuarioFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter, which Usuario to fetch.
     */
    where: UsuarioWhereUniqueInput
  }

  /**
   * Usuario findFirst
   */
  export type UsuarioFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter, which Usuario to fetch.
     */
    where?: UsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Usuarios to fetch.
     */
    orderBy?: UsuarioOrderByWithRelationInput | UsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Usuarios.
     */
    cursor?: UsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Usuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Usuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Usuarios.
     */
    distinct?: UsuarioScalarFieldEnum | UsuarioScalarFieldEnum[]
  }

  /**
   * Usuario findFirstOrThrow
   */
  export type UsuarioFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter, which Usuario to fetch.
     */
    where?: UsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Usuarios to fetch.
     */
    orderBy?: UsuarioOrderByWithRelationInput | UsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Usuarios.
     */
    cursor?: UsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Usuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Usuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Usuarios.
     */
    distinct?: UsuarioScalarFieldEnum | UsuarioScalarFieldEnum[]
  }

  /**
   * Usuario findMany
   */
  export type UsuarioFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter, which Usuarios to fetch.
     */
    where?: UsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Usuarios to fetch.
     */
    orderBy?: UsuarioOrderByWithRelationInput | UsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Usuarios.
     */
    cursor?: UsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Usuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Usuarios.
     */
    skip?: number
    distinct?: UsuarioScalarFieldEnum | UsuarioScalarFieldEnum[]
  }

  /**
   * Usuario create
   */
  export type UsuarioCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * The data needed to create a Usuario.
     */
    data: XOR<UsuarioCreateInput, UsuarioUncheckedCreateInput>
  }

  /**
   * Usuario createMany
   */
  export type UsuarioCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Usuarios.
     */
    data: UsuarioCreateManyInput | UsuarioCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Usuario update
   */
  export type UsuarioUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * The data needed to update a Usuario.
     */
    data: XOR<UsuarioUpdateInput, UsuarioUncheckedUpdateInput>
    /**
     * Choose, which Usuario to update.
     */
    where: UsuarioWhereUniqueInput
  }

  /**
   * Usuario updateMany
   */
  export type UsuarioUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Usuarios.
     */
    data: XOR<UsuarioUpdateManyMutationInput, UsuarioUncheckedUpdateManyInput>
    /**
     * Filter which Usuarios to update
     */
    where?: UsuarioWhereInput
  }

  /**
   * Usuario upsert
   */
  export type UsuarioUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * The filter to search for the Usuario to update in case it exists.
     */
    where: UsuarioWhereUniqueInput
    /**
     * In case the Usuario found by the `where` argument doesn't exist, create a new Usuario with this data.
     */
    create: XOR<UsuarioCreateInput, UsuarioUncheckedCreateInput>
    /**
     * In case the Usuario was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UsuarioUpdateInput, UsuarioUncheckedUpdateInput>
  }

  /**
   * Usuario delete
   */
  export type UsuarioDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
    /**
     * Filter which Usuario to delete.
     */
    where: UsuarioWhereUniqueInput
  }

  /**
   * Usuario deleteMany
   */
  export type UsuarioDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Usuarios to delete
     */
    where?: UsuarioWhereInput
  }

  /**
   * Usuario.trocas
   */
  export type Usuario$trocasArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    where?: TrocaWhereInput
    orderBy?: TrocaOrderByWithRelationInput | TrocaOrderByWithRelationInput[]
    cursor?: TrocaWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TrocaScalarFieldEnum | TrocaScalarFieldEnum[]
  }

  /**
   * Usuario.cartao_usuario
   */
  export type Usuario$cartao_usuarioArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    where?: CartaoUsuarioWhereInput
  }

  /**
   * Usuario without action
   */
  export type UsuarioDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Usuario
     */
    select?: UsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UsuarioInclude<ExtArgs> | null
  }


  /**
   * Model Cartao
   */

  export type AggregateCartao = {
    _count: CartaoCountAggregateOutputType | null
    _min: CartaoMinAggregateOutputType | null
    _max: CartaoMaxAggregateOutputType | null
  }

  export type CartaoMinAggregateOutputType = {
    id: string | null
    numero: string | null
    estado: boolean | null
  }

  export type CartaoMaxAggregateOutputType = {
    id: string | null
    numero: string | null
    estado: boolean | null
  }

  export type CartaoCountAggregateOutputType = {
    id: number
    numero: number
    estado: number
    _all: number
  }


  export type CartaoMinAggregateInputType = {
    id?: true
    numero?: true
    estado?: true
  }

  export type CartaoMaxAggregateInputType = {
    id?: true
    numero?: true
    estado?: true
  }

  export type CartaoCountAggregateInputType = {
    id?: true
    numero?: true
    estado?: true
    _all?: true
  }

  export type CartaoAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Cartao to aggregate.
     */
    where?: CartaoWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Cartaos to fetch.
     */
    orderBy?: CartaoOrderByWithRelationInput | CartaoOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CartaoWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Cartaos from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Cartaos.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Cartaos
    **/
    _count?: true | CartaoCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CartaoMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CartaoMaxAggregateInputType
  }

  export type GetCartaoAggregateType<T extends CartaoAggregateArgs> = {
        [P in keyof T & keyof AggregateCartao]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCartao[P]>
      : GetScalarType<T[P], AggregateCartao[P]>
  }




  export type CartaoGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CartaoWhereInput
    orderBy?: CartaoOrderByWithAggregationInput | CartaoOrderByWithAggregationInput[]
    by: CartaoScalarFieldEnum[] | CartaoScalarFieldEnum
    having?: CartaoScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CartaoCountAggregateInputType | true
    _min?: CartaoMinAggregateInputType
    _max?: CartaoMaxAggregateInputType
  }

  export type CartaoGroupByOutputType = {
    id: string
    numero: string
    estado: boolean
    _count: CartaoCountAggregateOutputType | null
    _min: CartaoMinAggregateOutputType | null
    _max: CartaoMaxAggregateOutputType | null
  }

  type GetCartaoGroupByPayload<T extends CartaoGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CartaoGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CartaoGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CartaoGroupByOutputType[P]>
            : GetScalarType<T[P], CartaoGroupByOutputType[P]>
        }
      >
    >


  export type CartaoSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    numero?: boolean
    estado?: boolean
    cartao_usuario?: boolean | Cartao$cartao_usuarioArgs<ExtArgs>
  }, ExtArgs["result"]["cartao"]>


  export type CartaoSelectScalar = {
    id?: boolean
    numero?: boolean
    estado?: boolean
  }

  export type CartaoInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    cartao_usuario?: boolean | Cartao$cartao_usuarioArgs<ExtArgs>
  }

  export type $CartaoPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Cartao"
    objects: {
      cartao_usuario: Prisma.$CartaoUsuarioPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      numero: string
      estado: boolean
    }, ExtArgs["result"]["cartao"]>
    composites: {}
  }

  type CartaoGetPayload<S extends boolean | null | undefined | CartaoDefaultArgs> = $Result.GetResult<Prisma.$CartaoPayload, S>

  type CartaoCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CartaoFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CartaoCountAggregateInputType | true
    }

  export interface CartaoDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Cartao'], meta: { name: 'Cartao' } }
    /**
     * Find zero or one Cartao that matches the filter.
     * @param {CartaoFindUniqueArgs} args - Arguments to find a Cartao
     * @example
     * // Get one Cartao
     * const cartao = await prisma.cartao.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CartaoFindUniqueArgs>(args: SelectSubset<T, CartaoFindUniqueArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Cartao that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CartaoFindUniqueOrThrowArgs} args - Arguments to find a Cartao
     * @example
     * // Get one Cartao
     * const cartao = await prisma.cartao.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CartaoFindUniqueOrThrowArgs>(args: SelectSubset<T, CartaoFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Cartao that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoFindFirstArgs} args - Arguments to find a Cartao
     * @example
     * // Get one Cartao
     * const cartao = await prisma.cartao.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CartaoFindFirstArgs>(args?: SelectSubset<T, CartaoFindFirstArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Cartao that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoFindFirstOrThrowArgs} args - Arguments to find a Cartao
     * @example
     * // Get one Cartao
     * const cartao = await prisma.cartao.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CartaoFindFirstOrThrowArgs>(args?: SelectSubset<T, CartaoFindFirstOrThrowArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Cartaos that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Cartaos
     * const cartaos = await prisma.cartao.findMany()
     * 
     * // Get first 10 Cartaos
     * const cartaos = await prisma.cartao.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const cartaoWithIdOnly = await prisma.cartao.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CartaoFindManyArgs>(args?: SelectSubset<T, CartaoFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Cartao.
     * @param {CartaoCreateArgs} args - Arguments to create a Cartao.
     * @example
     * // Create one Cartao
     * const Cartao = await prisma.cartao.create({
     *   data: {
     *     // ... data to create a Cartao
     *   }
     * })
     * 
     */
    create<T extends CartaoCreateArgs>(args: SelectSubset<T, CartaoCreateArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Cartaos.
     * @param {CartaoCreateManyArgs} args - Arguments to create many Cartaos.
     * @example
     * // Create many Cartaos
     * const cartao = await prisma.cartao.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CartaoCreateManyArgs>(args?: SelectSubset<T, CartaoCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Cartao.
     * @param {CartaoDeleteArgs} args - Arguments to delete one Cartao.
     * @example
     * // Delete one Cartao
     * const Cartao = await prisma.cartao.delete({
     *   where: {
     *     // ... filter to delete one Cartao
     *   }
     * })
     * 
     */
    delete<T extends CartaoDeleteArgs>(args: SelectSubset<T, CartaoDeleteArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Cartao.
     * @param {CartaoUpdateArgs} args - Arguments to update one Cartao.
     * @example
     * // Update one Cartao
     * const cartao = await prisma.cartao.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CartaoUpdateArgs>(args: SelectSubset<T, CartaoUpdateArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Cartaos.
     * @param {CartaoDeleteManyArgs} args - Arguments to filter Cartaos to delete.
     * @example
     * // Delete a few Cartaos
     * const { count } = await prisma.cartao.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CartaoDeleteManyArgs>(args?: SelectSubset<T, CartaoDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Cartaos.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Cartaos
     * const cartao = await prisma.cartao.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CartaoUpdateManyArgs>(args: SelectSubset<T, CartaoUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Cartao.
     * @param {CartaoUpsertArgs} args - Arguments to update or create a Cartao.
     * @example
     * // Update or create a Cartao
     * const cartao = await prisma.cartao.upsert({
     *   create: {
     *     // ... data to create a Cartao
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Cartao we want to update
     *   }
     * })
     */
    upsert<T extends CartaoUpsertArgs>(args: SelectSubset<T, CartaoUpsertArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Cartaos.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoCountArgs} args - Arguments to filter Cartaos to count.
     * @example
     * // Count the number of Cartaos
     * const count = await prisma.cartao.count({
     *   where: {
     *     // ... the filter for the Cartaos we want to count
     *   }
     * })
    **/
    count<T extends CartaoCountArgs>(
      args?: Subset<T, CartaoCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CartaoCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Cartao.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CartaoAggregateArgs>(args: Subset<T, CartaoAggregateArgs>): Prisma.PrismaPromise<GetCartaoAggregateType<T>>

    /**
     * Group by Cartao.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CartaoGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CartaoGroupByArgs['orderBy'] }
        : { orderBy?: CartaoGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CartaoGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCartaoGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Cartao model
   */
  readonly fields: CartaoFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Cartao.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CartaoClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    cartao_usuario<T extends Cartao$cartao_usuarioArgs<ExtArgs> = {}>(args?: Subset<T, Cartao$cartao_usuarioArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Cartao model
   */ 
  interface CartaoFieldRefs {
    readonly id: FieldRef<"Cartao", 'String'>
    readonly numero: FieldRef<"Cartao", 'String'>
    readonly estado: FieldRef<"Cartao", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * Cartao findUnique
   */
  export type CartaoFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter, which Cartao to fetch.
     */
    where: CartaoWhereUniqueInput
  }

  /**
   * Cartao findUniqueOrThrow
   */
  export type CartaoFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter, which Cartao to fetch.
     */
    where: CartaoWhereUniqueInput
  }

  /**
   * Cartao findFirst
   */
  export type CartaoFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter, which Cartao to fetch.
     */
    where?: CartaoWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Cartaos to fetch.
     */
    orderBy?: CartaoOrderByWithRelationInput | CartaoOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Cartaos.
     */
    cursor?: CartaoWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Cartaos from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Cartaos.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Cartaos.
     */
    distinct?: CartaoScalarFieldEnum | CartaoScalarFieldEnum[]
  }

  /**
   * Cartao findFirstOrThrow
   */
  export type CartaoFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter, which Cartao to fetch.
     */
    where?: CartaoWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Cartaos to fetch.
     */
    orderBy?: CartaoOrderByWithRelationInput | CartaoOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Cartaos.
     */
    cursor?: CartaoWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Cartaos from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Cartaos.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Cartaos.
     */
    distinct?: CartaoScalarFieldEnum | CartaoScalarFieldEnum[]
  }

  /**
   * Cartao findMany
   */
  export type CartaoFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter, which Cartaos to fetch.
     */
    where?: CartaoWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Cartaos to fetch.
     */
    orderBy?: CartaoOrderByWithRelationInput | CartaoOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Cartaos.
     */
    cursor?: CartaoWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Cartaos from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Cartaos.
     */
    skip?: number
    distinct?: CartaoScalarFieldEnum | CartaoScalarFieldEnum[]
  }

  /**
   * Cartao create
   */
  export type CartaoCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * The data needed to create a Cartao.
     */
    data: XOR<CartaoCreateInput, CartaoUncheckedCreateInput>
  }

  /**
   * Cartao createMany
   */
  export type CartaoCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Cartaos.
     */
    data: CartaoCreateManyInput | CartaoCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Cartao update
   */
  export type CartaoUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * The data needed to update a Cartao.
     */
    data: XOR<CartaoUpdateInput, CartaoUncheckedUpdateInput>
    /**
     * Choose, which Cartao to update.
     */
    where: CartaoWhereUniqueInput
  }

  /**
   * Cartao updateMany
   */
  export type CartaoUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Cartaos.
     */
    data: XOR<CartaoUpdateManyMutationInput, CartaoUncheckedUpdateManyInput>
    /**
     * Filter which Cartaos to update
     */
    where?: CartaoWhereInput
  }

  /**
   * Cartao upsert
   */
  export type CartaoUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * The filter to search for the Cartao to update in case it exists.
     */
    where: CartaoWhereUniqueInput
    /**
     * In case the Cartao found by the `where` argument doesn't exist, create a new Cartao with this data.
     */
    create: XOR<CartaoCreateInput, CartaoUncheckedCreateInput>
    /**
     * In case the Cartao was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CartaoUpdateInput, CartaoUncheckedUpdateInput>
  }

  /**
   * Cartao delete
   */
  export type CartaoDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
    /**
     * Filter which Cartao to delete.
     */
    where: CartaoWhereUniqueInput
  }

  /**
   * Cartao deleteMany
   */
  export type CartaoDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Cartaos to delete
     */
    where?: CartaoWhereInput
  }

  /**
   * Cartao.cartao_usuario
   */
  export type Cartao$cartao_usuarioArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    where?: CartaoUsuarioWhereInput
  }

  /**
   * Cartao without action
   */
  export type CartaoDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Cartao
     */
    select?: CartaoSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoInclude<ExtArgs> | null
  }


  /**
   * Model CartaoUsuario
   */

  export type AggregateCartaoUsuario = {
    _count: CartaoUsuarioCountAggregateOutputType | null
    _min: CartaoUsuarioMinAggregateOutputType | null
    _max: CartaoUsuarioMaxAggregateOutputType | null
  }

  export type CartaoUsuarioMinAggregateOutputType = {
    id: string | null
    id_cartao: string | null
    id_usuario: string | null
    estado: boolean | null
  }

  export type CartaoUsuarioMaxAggregateOutputType = {
    id: string | null
    id_cartao: string | null
    id_usuario: string | null
    estado: boolean | null
  }

  export type CartaoUsuarioCountAggregateOutputType = {
    id: number
    id_cartao: number
    id_usuario: number
    estado: number
    _all: number
  }


  export type CartaoUsuarioMinAggregateInputType = {
    id?: true
    id_cartao?: true
    id_usuario?: true
    estado?: true
  }

  export type CartaoUsuarioMaxAggregateInputType = {
    id?: true
    id_cartao?: true
    id_usuario?: true
    estado?: true
  }

  export type CartaoUsuarioCountAggregateInputType = {
    id?: true
    id_cartao?: true
    id_usuario?: true
    estado?: true
    _all?: true
  }

  export type CartaoUsuarioAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CartaoUsuario to aggregate.
     */
    where?: CartaoUsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CartaoUsuarios to fetch.
     */
    orderBy?: CartaoUsuarioOrderByWithRelationInput | CartaoUsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CartaoUsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CartaoUsuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CartaoUsuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned CartaoUsuarios
    **/
    _count?: true | CartaoUsuarioCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CartaoUsuarioMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CartaoUsuarioMaxAggregateInputType
  }

  export type GetCartaoUsuarioAggregateType<T extends CartaoUsuarioAggregateArgs> = {
        [P in keyof T & keyof AggregateCartaoUsuario]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCartaoUsuario[P]>
      : GetScalarType<T[P], AggregateCartaoUsuario[P]>
  }




  export type CartaoUsuarioGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CartaoUsuarioWhereInput
    orderBy?: CartaoUsuarioOrderByWithAggregationInput | CartaoUsuarioOrderByWithAggregationInput[]
    by: CartaoUsuarioScalarFieldEnum[] | CartaoUsuarioScalarFieldEnum
    having?: CartaoUsuarioScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CartaoUsuarioCountAggregateInputType | true
    _min?: CartaoUsuarioMinAggregateInputType
    _max?: CartaoUsuarioMaxAggregateInputType
  }

  export type CartaoUsuarioGroupByOutputType = {
    id: string
    id_cartao: string
    id_usuario: string
    estado: boolean
    _count: CartaoUsuarioCountAggregateOutputType | null
    _min: CartaoUsuarioMinAggregateOutputType | null
    _max: CartaoUsuarioMaxAggregateOutputType | null
  }

  type GetCartaoUsuarioGroupByPayload<T extends CartaoUsuarioGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CartaoUsuarioGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CartaoUsuarioGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CartaoUsuarioGroupByOutputType[P]>
            : GetScalarType<T[P], CartaoUsuarioGroupByOutputType[P]>
        }
      >
    >


  export type CartaoUsuarioSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    id_cartao?: boolean
    id_usuario?: boolean
    estado?: boolean
    cartao?: boolean | CartaoDefaultArgs<ExtArgs>
    usuario?: boolean | UsuarioDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["cartaoUsuario"]>


  export type CartaoUsuarioSelectScalar = {
    id?: boolean
    id_cartao?: boolean
    id_usuario?: boolean
    estado?: boolean
  }

  export type CartaoUsuarioInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    cartao?: boolean | CartaoDefaultArgs<ExtArgs>
    usuario?: boolean | UsuarioDefaultArgs<ExtArgs>
  }

  export type $CartaoUsuarioPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "CartaoUsuario"
    objects: {
      cartao: Prisma.$CartaoPayload<ExtArgs>
      usuario: Prisma.$UsuarioPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      id_cartao: string
      id_usuario: string
      estado: boolean
    }, ExtArgs["result"]["cartaoUsuario"]>
    composites: {}
  }

  type CartaoUsuarioGetPayload<S extends boolean | null | undefined | CartaoUsuarioDefaultArgs> = $Result.GetResult<Prisma.$CartaoUsuarioPayload, S>

  type CartaoUsuarioCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CartaoUsuarioFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CartaoUsuarioCountAggregateInputType | true
    }

  export interface CartaoUsuarioDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['CartaoUsuario'], meta: { name: 'CartaoUsuario' } }
    /**
     * Find zero or one CartaoUsuario that matches the filter.
     * @param {CartaoUsuarioFindUniqueArgs} args - Arguments to find a CartaoUsuario
     * @example
     * // Get one CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CartaoUsuarioFindUniqueArgs>(args: SelectSubset<T, CartaoUsuarioFindUniqueArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one CartaoUsuario that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CartaoUsuarioFindUniqueOrThrowArgs} args - Arguments to find a CartaoUsuario
     * @example
     * // Get one CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CartaoUsuarioFindUniqueOrThrowArgs>(args: SelectSubset<T, CartaoUsuarioFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first CartaoUsuario that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioFindFirstArgs} args - Arguments to find a CartaoUsuario
     * @example
     * // Get one CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CartaoUsuarioFindFirstArgs>(args?: SelectSubset<T, CartaoUsuarioFindFirstArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first CartaoUsuario that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioFindFirstOrThrowArgs} args - Arguments to find a CartaoUsuario
     * @example
     * // Get one CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CartaoUsuarioFindFirstOrThrowArgs>(args?: SelectSubset<T, CartaoUsuarioFindFirstOrThrowArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more CartaoUsuarios that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all CartaoUsuarios
     * const cartaoUsuarios = await prisma.cartaoUsuario.findMany()
     * 
     * // Get first 10 CartaoUsuarios
     * const cartaoUsuarios = await prisma.cartaoUsuario.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const cartaoUsuarioWithIdOnly = await prisma.cartaoUsuario.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CartaoUsuarioFindManyArgs>(args?: SelectSubset<T, CartaoUsuarioFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a CartaoUsuario.
     * @param {CartaoUsuarioCreateArgs} args - Arguments to create a CartaoUsuario.
     * @example
     * // Create one CartaoUsuario
     * const CartaoUsuario = await prisma.cartaoUsuario.create({
     *   data: {
     *     // ... data to create a CartaoUsuario
     *   }
     * })
     * 
     */
    create<T extends CartaoUsuarioCreateArgs>(args: SelectSubset<T, CartaoUsuarioCreateArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many CartaoUsuarios.
     * @param {CartaoUsuarioCreateManyArgs} args - Arguments to create many CartaoUsuarios.
     * @example
     * // Create many CartaoUsuarios
     * const cartaoUsuario = await prisma.cartaoUsuario.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CartaoUsuarioCreateManyArgs>(args?: SelectSubset<T, CartaoUsuarioCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a CartaoUsuario.
     * @param {CartaoUsuarioDeleteArgs} args - Arguments to delete one CartaoUsuario.
     * @example
     * // Delete one CartaoUsuario
     * const CartaoUsuario = await prisma.cartaoUsuario.delete({
     *   where: {
     *     // ... filter to delete one CartaoUsuario
     *   }
     * })
     * 
     */
    delete<T extends CartaoUsuarioDeleteArgs>(args: SelectSubset<T, CartaoUsuarioDeleteArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one CartaoUsuario.
     * @param {CartaoUsuarioUpdateArgs} args - Arguments to update one CartaoUsuario.
     * @example
     * // Update one CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CartaoUsuarioUpdateArgs>(args: SelectSubset<T, CartaoUsuarioUpdateArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more CartaoUsuarios.
     * @param {CartaoUsuarioDeleteManyArgs} args - Arguments to filter CartaoUsuarios to delete.
     * @example
     * // Delete a few CartaoUsuarios
     * const { count } = await prisma.cartaoUsuario.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CartaoUsuarioDeleteManyArgs>(args?: SelectSubset<T, CartaoUsuarioDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more CartaoUsuarios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many CartaoUsuarios
     * const cartaoUsuario = await prisma.cartaoUsuario.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CartaoUsuarioUpdateManyArgs>(args: SelectSubset<T, CartaoUsuarioUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one CartaoUsuario.
     * @param {CartaoUsuarioUpsertArgs} args - Arguments to update or create a CartaoUsuario.
     * @example
     * // Update or create a CartaoUsuario
     * const cartaoUsuario = await prisma.cartaoUsuario.upsert({
     *   create: {
     *     // ... data to create a CartaoUsuario
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the CartaoUsuario we want to update
     *   }
     * })
     */
    upsert<T extends CartaoUsuarioUpsertArgs>(args: SelectSubset<T, CartaoUsuarioUpsertArgs<ExtArgs>>): Prisma__CartaoUsuarioClient<$Result.GetResult<Prisma.$CartaoUsuarioPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of CartaoUsuarios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioCountArgs} args - Arguments to filter CartaoUsuarios to count.
     * @example
     * // Count the number of CartaoUsuarios
     * const count = await prisma.cartaoUsuario.count({
     *   where: {
     *     // ... the filter for the CartaoUsuarios we want to count
     *   }
     * })
    **/
    count<T extends CartaoUsuarioCountArgs>(
      args?: Subset<T, CartaoUsuarioCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CartaoUsuarioCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a CartaoUsuario.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CartaoUsuarioAggregateArgs>(args: Subset<T, CartaoUsuarioAggregateArgs>): Prisma.PrismaPromise<GetCartaoUsuarioAggregateType<T>>

    /**
     * Group by CartaoUsuario.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CartaoUsuarioGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CartaoUsuarioGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CartaoUsuarioGroupByArgs['orderBy'] }
        : { orderBy?: CartaoUsuarioGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CartaoUsuarioGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCartaoUsuarioGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the CartaoUsuario model
   */
  readonly fields: CartaoUsuarioFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for CartaoUsuario.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CartaoUsuarioClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    cartao<T extends CartaoDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CartaoDefaultArgs<ExtArgs>>): Prisma__CartaoClient<$Result.GetResult<Prisma.$CartaoPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    usuario<T extends UsuarioDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UsuarioDefaultArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the CartaoUsuario model
   */ 
  interface CartaoUsuarioFieldRefs {
    readonly id: FieldRef<"CartaoUsuario", 'String'>
    readonly id_cartao: FieldRef<"CartaoUsuario", 'String'>
    readonly id_usuario: FieldRef<"CartaoUsuario", 'String'>
    readonly estado: FieldRef<"CartaoUsuario", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * CartaoUsuario findUnique
   */
  export type CartaoUsuarioFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter, which CartaoUsuario to fetch.
     */
    where: CartaoUsuarioWhereUniqueInput
  }

  /**
   * CartaoUsuario findUniqueOrThrow
   */
  export type CartaoUsuarioFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter, which CartaoUsuario to fetch.
     */
    where: CartaoUsuarioWhereUniqueInput
  }

  /**
   * CartaoUsuario findFirst
   */
  export type CartaoUsuarioFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter, which CartaoUsuario to fetch.
     */
    where?: CartaoUsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CartaoUsuarios to fetch.
     */
    orderBy?: CartaoUsuarioOrderByWithRelationInput | CartaoUsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CartaoUsuarios.
     */
    cursor?: CartaoUsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CartaoUsuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CartaoUsuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CartaoUsuarios.
     */
    distinct?: CartaoUsuarioScalarFieldEnum | CartaoUsuarioScalarFieldEnum[]
  }

  /**
   * CartaoUsuario findFirstOrThrow
   */
  export type CartaoUsuarioFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter, which CartaoUsuario to fetch.
     */
    where?: CartaoUsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CartaoUsuarios to fetch.
     */
    orderBy?: CartaoUsuarioOrderByWithRelationInput | CartaoUsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CartaoUsuarios.
     */
    cursor?: CartaoUsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CartaoUsuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CartaoUsuarios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CartaoUsuarios.
     */
    distinct?: CartaoUsuarioScalarFieldEnum | CartaoUsuarioScalarFieldEnum[]
  }

  /**
   * CartaoUsuario findMany
   */
  export type CartaoUsuarioFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter, which CartaoUsuarios to fetch.
     */
    where?: CartaoUsuarioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CartaoUsuarios to fetch.
     */
    orderBy?: CartaoUsuarioOrderByWithRelationInput | CartaoUsuarioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing CartaoUsuarios.
     */
    cursor?: CartaoUsuarioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CartaoUsuarios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CartaoUsuarios.
     */
    skip?: number
    distinct?: CartaoUsuarioScalarFieldEnum | CartaoUsuarioScalarFieldEnum[]
  }

  /**
   * CartaoUsuario create
   */
  export type CartaoUsuarioCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * The data needed to create a CartaoUsuario.
     */
    data: XOR<CartaoUsuarioCreateInput, CartaoUsuarioUncheckedCreateInput>
  }

  /**
   * CartaoUsuario createMany
   */
  export type CartaoUsuarioCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many CartaoUsuarios.
     */
    data: CartaoUsuarioCreateManyInput | CartaoUsuarioCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * CartaoUsuario update
   */
  export type CartaoUsuarioUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * The data needed to update a CartaoUsuario.
     */
    data: XOR<CartaoUsuarioUpdateInput, CartaoUsuarioUncheckedUpdateInput>
    /**
     * Choose, which CartaoUsuario to update.
     */
    where: CartaoUsuarioWhereUniqueInput
  }

  /**
   * CartaoUsuario updateMany
   */
  export type CartaoUsuarioUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update CartaoUsuarios.
     */
    data: XOR<CartaoUsuarioUpdateManyMutationInput, CartaoUsuarioUncheckedUpdateManyInput>
    /**
     * Filter which CartaoUsuarios to update
     */
    where?: CartaoUsuarioWhereInput
  }

  /**
   * CartaoUsuario upsert
   */
  export type CartaoUsuarioUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * The filter to search for the CartaoUsuario to update in case it exists.
     */
    where: CartaoUsuarioWhereUniqueInput
    /**
     * In case the CartaoUsuario found by the `where` argument doesn't exist, create a new CartaoUsuario with this data.
     */
    create: XOR<CartaoUsuarioCreateInput, CartaoUsuarioUncheckedCreateInput>
    /**
     * In case the CartaoUsuario was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CartaoUsuarioUpdateInput, CartaoUsuarioUncheckedUpdateInput>
  }

  /**
   * CartaoUsuario delete
   */
  export type CartaoUsuarioDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
    /**
     * Filter which CartaoUsuario to delete.
     */
    where: CartaoUsuarioWhereUniqueInput
  }

  /**
   * CartaoUsuario deleteMany
   */
  export type CartaoUsuarioDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CartaoUsuarios to delete
     */
    where?: CartaoUsuarioWhereInput
  }

  /**
   * CartaoUsuario without action
   */
  export type CartaoUsuarioDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CartaoUsuario
     */
    select?: CartaoUsuarioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CartaoUsuarioInclude<ExtArgs> | null
  }


  /**
   * Model Referencia
   */

  export type AggregateReferencia = {
    _count: ReferenciaCountAggregateOutputType | null
    _min: ReferenciaMinAggregateOutputType | null
    _max: ReferenciaMaxAggregateOutputType | null
  }

  export type ReferenciaMinAggregateOutputType = {
    id: string | null
    codigo: string | null
    usado: boolean | null
    data: Date | null
    id_beneficio: string | null
  }

  export type ReferenciaMaxAggregateOutputType = {
    id: string | null
    codigo: string | null
    usado: boolean | null
    data: Date | null
    id_beneficio: string | null
  }

  export type ReferenciaCountAggregateOutputType = {
    id: number
    codigo: number
    usado: number
    data: number
    id_beneficio: number
    _all: number
  }


  export type ReferenciaMinAggregateInputType = {
    id?: true
    codigo?: true
    usado?: true
    data?: true
    id_beneficio?: true
  }

  export type ReferenciaMaxAggregateInputType = {
    id?: true
    codigo?: true
    usado?: true
    data?: true
    id_beneficio?: true
  }

  export type ReferenciaCountAggregateInputType = {
    id?: true
    codigo?: true
    usado?: true
    data?: true
    id_beneficio?: true
    _all?: true
  }

  export type ReferenciaAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Referencia to aggregate.
     */
    where?: ReferenciaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Referencias to fetch.
     */
    orderBy?: ReferenciaOrderByWithRelationInput | ReferenciaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ReferenciaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Referencias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Referencias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Referencias
    **/
    _count?: true | ReferenciaCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ReferenciaMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ReferenciaMaxAggregateInputType
  }

  export type GetReferenciaAggregateType<T extends ReferenciaAggregateArgs> = {
        [P in keyof T & keyof AggregateReferencia]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateReferencia[P]>
      : GetScalarType<T[P], AggregateReferencia[P]>
  }




  export type ReferenciaGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferenciaWhereInput
    orderBy?: ReferenciaOrderByWithAggregationInput | ReferenciaOrderByWithAggregationInput[]
    by: ReferenciaScalarFieldEnum[] | ReferenciaScalarFieldEnum
    having?: ReferenciaScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ReferenciaCountAggregateInputType | true
    _min?: ReferenciaMinAggregateInputType
    _max?: ReferenciaMaxAggregateInputType
  }

  export type ReferenciaGroupByOutputType = {
    id: string
    codigo: string
    usado: boolean
    data: Date
    id_beneficio: string
    _count: ReferenciaCountAggregateOutputType | null
    _min: ReferenciaMinAggregateOutputType | null
    _max: ReferenciaMaxAggregateOutputType | null
  }

  type GetReferenciaGroupByPayload<T extends ReferenciaGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ReferenciaGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ReferenciaGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ReferenciaGroupByOutputType[P]>
            : GetScalarType<T[P], ReferenciaGroupByOutputType[P]>
        }
      >
    >


  export type ReferenciaSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    codigo?: boolean
    usado?: boolean
    data?: boolean
    id_beneficio?: boolean
    beneficio?: boolean | BeneficioDefaultArgs<ExtArgs>
    troca?: boolean | Referencia$trocaArgs<ExtArgs>
  }, ExtArgs["result"]["referencia"]>


  export type ReferenciaSelectScalar = {
    id?: boolean
    codigo?: boolean
    usado?: boolean
    data?: boolean
    id_beneficio?: boolean
  }

  export type ReferenciaInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    beneficio?: boolean | BeneficioDefaultArgs<ExtArgs>
    troca?: boolean | Referencia$trocaArgs<ExtArgs>
  }

  export type $ReferenciaPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Referencia"
    objects: {
      beneficio: Prisma.$BeneficioPayload<ExtArgs>
      troca: Prisma.$TrocaPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      codigo: string
      usado: boolean
      data: Date
      id_beneficio: string
    }, ExtArgs["result"]["referencia"]>
    composites: {}
  }

  type ReferenciaGetPayload<S extends boolean | null | undefined | ReferenciaDefaultArgs> = $Result.GetResult<Prisma.$ReferenciaPayload, S>

  type ReferenciaCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ReferenciaFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ReferenciaCountAggregateInputType | true
    }

  export interface ReferenciaDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Referencia'], meta: { name: 'Referencia' } }
    /**
     * Find zero or one Referencia that matches the filter.
     * @param {ReferenciaFindUniqueArgs} args - Arguments to find a Referencia
     * @example
     * // Get one Referencia
     * const referencia = await prisma.referencia.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ReferenciaFindUniqueArgs>(args: SelectSubset<T, ReferenciaFindUniqueArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Referencia that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ReferenciaFindUniqueOrThrowArgs} args - Arguments to find a Referencia
     * @example
     * // Get one Referencia
     * const referencia = await prisma.referencia.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ReferenciaFindUniqueOrThrowArgs>(args: SelectSubset<T, ReferenciaFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Referencia that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaFindFirstArgs} args - Arguments to find a Referencia
     * @example
     * // Get one Referencia
     * const referencia = await prisma.referencia.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ReferenciaFindFirstArgs>(args?: SelectSubset<T, ReferenciaFindFirstArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Referencia that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaFindFirstOrThrowArgs} args - Arguments to find a Referencia
     * @example
     * // Get one Referencia
     * const referencia = await prisma.referencia.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ReferenciaFindFirstOrThrowArgs>(args?: SelectSubset<T, ReferenciaFindFirstOrThrowArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Referencias that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Referencias
     * const referencias = await prisma.referencia.findMany()
     * 
     * // Get first 10 Referencias
     * const referencias = await prisma.referencia.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const referenciaWithIdOnly = await prisma.referencia.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ReferenciaFindManyArgs>(args?: SelectSubset<T, ReferenciaFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Referencia.
     * @param {ReferenciaCreateArgs} args - Arguments to create a Referencia.
     * @example
     * // Create one Referencia
     * const Referencia = await prisma.referencia.create({
     *   data: {
     *     // ... data to create a Referencia
     *   }
     * })
     * 
     */
    create<T extends ReferenciaCreateArgs>(args: SelectSubset<T, ReferenciaCreateArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Referencias.
     * @param {ReferenciaCreateManyArgs} args - Arguments to create many Referencias.
     * @example
     * // Create many Referencias
     * const referencia = await prisma.referencia.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ReferenciaCreateManyArgs>(args?: SelectSubset<T, ReferenciaCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Referencia.
     * @param {ReferenciaDeleteArgs} args - Arguments to delete one Referencia.
     * @example
     * // Delete one Referencia
     * const Referencia = await prisma.referencia.delete({
     *   where: {
     *     // ... filter to delete one Referencia
     *   }
     * })
     * 
     */
    delete<T extends ReferenciaDeleteArgs>(args: SelectSubset<T, ReferenciaDeleteArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Referencia.
     * @param {ReferenciaUpdateArgs} args - Arguments to update one Referencia.
     * @example
     * // Update one Referencia
     * const referencia = await prisma.referencia.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ReferenciaUpdateArgs>(args: SelectSubset<T, ReferenciaUpdateArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Referencias.
     * @param {ReferenciaDeleteManyArgs} args - Arguments to filter Referencias to delete.
     * @example
     * // Delete a few Referencias
     * const { count } = await prisma.referencia.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ReferenciaDeleteManyArgs>(args?: SelectSubset<T, ReferenciaDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Referencias.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Referencias
     * const referencia = await prisma.referencia.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ReferenciaUpdateManyArgs>(args: SelectSubset<T, ReferenciaUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Referencia.
     * @param {ReferenciaUpsertArgs} args - Arguments to update or create a Referencia.
     * @example
     * // Update or create a Referencia
     * const referencia = await prisma.referencia.upsert({
     *   create: {
     *     // ... data to create a Referencia
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Referencia we want to update
     *   }
     * })
     */
    upsert<T extends ReferenciaUpsertArgs>(args: SelectSubset<T, ReferenciaUpsertArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Referencias.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaCountArgs} args - Arguments to filter Referencias to count.
     * @example
     * // Count the number of Referencias
     * const count = await prisma.referencia.count({
     *   where: {
     *     // ... the filter for the Referencias we want to count
     *   }
     * })
    **/
    count<T extends ReferenciaCountArgs>(
      args?: Subset<T, ReferenciaCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ReferenciaCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Referencia.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ReferenciaAggregateArgs>(args: Subset<T, ReferenciaAggregateArgs>): Prisma.PrismaPromise<GetReferenciaAggregateType<T>>

    /**
     * Group by Referencia.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferenciaGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ReferenciaGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ReferenciaGroupByArgs['orderBy'] }
        : { orderBy?: ReferenciaGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ReferenciaGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetReferenciaGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Referencia model
   */
  readonly fields: ReferenciaFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Referencia.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ReferenciaClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    beneficio<T extends BeneficioDefaultArgs<ExtArgs> = {}>(args?: Subset<T, BeneficioDefaultArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    troca<T extends Referencia$trocaArgs<ExtArgs> = {}>(args?: Subset<T, Referencia$trocaArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findUniqueOrThrow"> | null, null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Referencia model
   */ 
  interface ReferenciaFieldRefs {
    readonly id: FieldRef<"Referencia", 'String'>
    readonly codigo: FieldRef<"Referencia", 'String'>
    readonly usado: FieldRef<"Referencia", 'Boolean'>
    readonly data: FieldRef<"Referencia", 'DateTime'>
    readonly id_beneficio: FieldRef<"Referencia", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Referencia findUnique
   */
  export type ReferenciaFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter, which Referencia to fetch.
     */
    where: ReferenciaWhereUniqueInput
  }

  /**
   * Referencia findUniqueOrThrow
   */
  export type ReferenciaFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter, which Referencia to fetch.
     */
    where: ReferenciaWhereUniqueInput
  }

  /**
   * Referencia findFirst
   */
  export type ReferenciaFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter, which Referencia to fetch.
     */
    where?: ReferenciaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Referencias to fetch.
     */
    orderBy?: ReferenciaOrderByWithRelationInput | ReferenciaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Referencias.
     */
    cursor?: ReferenciaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Referencias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Referencias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Referencias.
     */
    distinct?: ReferenciaScalarFieldEnum | ReferenciaScalarFieldEnum[]
  }

  /**
   * Referencia findFirstOrThrow
   */
  export type ReferenciaFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter, which Referencia to fetch.
     */
    where?: ReferenciaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Referencias to fetch.
     */
    orderBy?: ReferenciaOrderByWithRelationInput | ReferenciaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Referencias.
     */
    cursor?: ReferenciaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Referencias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Referencias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Referencias.
     */
    distinct?: ReferenciaScalarFieldEnum | ReferenciaScalarFieldEnum[]
  }

  /**
   * Referencia findMany
   */
  export type ReferenciaFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter, which Referencias to fetch.
     */
    where?: ReferenciaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Referencias to fetch.
     */
    orderBy?: ReferenciaOrderByWithRelationInput | ReferenciaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Referencias.
     */
    cursor?: ReferenciaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Referencias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Referencias.
     */
    skip?: number
    distinct?: ReferenciaScalarFieldEnum | ReferenciaScalarFieldEnum[]
  }

  /**
   * Referencia create
   */
  export type ReferenciaCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * The data needed to create a Referencia.
     */
    data: XOR<ReferenciaCreateInput, ReferenciaUncheckedCreateInput>
  }

  /**
   * Referencia createMany
   */
  export type ReferenciaCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Referencias.
     */
    data: ReferenciaCreateManyInput | ReferenciaCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Referencia update
   */
  export type ReferenciaUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * The data needed to update a Referencia.
     */
    data: XOR<ReferenciaUpdateInput, ReferenciaUncheckedUpdateInput>
    /**
     * Choose, which Referencia to update.
     */
    where: ReferenciaWhereUniqueInput
  }

  /**
   * Referencia updateMany
   */
  export type ReferenciaUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Referencias.
     */
    data: XOR<ReferenciaUpdateManyMutationInput, ReferenciaUncheckedUpdateManyInput>
    /**
     * Filter which Referencias to update
     */
    where?: ReferenciaWhereInput
  }

  /**
   * Referencia upsert
   */
  export type ReferenciaUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * The filter to search for the Referencia to update in case it exists.
     */
    where: ReferenciaWhereUniqueInput
    /**
     * In case the Referencia found by the `where` argument doesn't exist, create a new Referencia with this data.
     */
    create: XOR<ReferenciaCreateInput, ReferenciaUncheckedCreateInput>
    /**
     * In case the Referencia was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ReferenciaUpdateInput, ReferenciaUncheckedUpdateInput>
  }

  /**
   * Referencia delete
   */
  export type ReferenciaDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    /**
     * Filter which Referencia to delete.
     */
    where: ReferenciaWhereUniqueInput
  }

  /**
   * Referencia deleteMany
   */
  export type ReferenciaDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Referencias to delete
     */
    where?: ReferenciaWhereInput
  }

  /**
   * Referencia.troca
   */
  export type Referencia$trocaArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    where?: TrocaWhereInput
  }

  /**
   * Referencia without action
   */
  export type ReferenciaDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
  }


  /**
   * Model Beneficio
   */

  export type AggregateBeneficio = {
    _count: BeneficioCountAggregateOutputType | null
    _avg: BeneficioAvgAggregateOutputType | null
    _sum: BeneficioSumAggregateOutputType | null
    _min: BeneficioMinAggregateOutputType | null
    _max: BeneficioMaxAggregateOutputType | null
  }

  export type BeneficioAvgAggregateOutputType = {
    pontos: number | null
  }

  export type BeneficioSumAggregateOutputType = {
    pontos: number | null
  }

  export type BeneficioMinAggregateOutputType = {
    id: string | null
    nome: string | null
    descricao: string | null
    pontos: number | null
    estado: boolean | null
    id_categoria: string | null
    created_at: Date | null
  }

  export type BeneficioMaxAggregateOutputType = {
    id: string | null
    nome: string | null
    descricao: string | null
    pontos: number | null
    estado: boolean | null
    id_categoria: string | null
    created_at: Date | null
  }

  export type BeneficioCountAggregateOutputType = {
    id: number
    nome: number
    descricao: number
    pontos: number
    estado: number
    id_categoria: number
    created_at: number
    _all: number
  }


  export type BeneficioAvgAggregateInputType = {
    pontos?: true
  }

  export type BeneficioSumAggregateInputType = {
    pontos?: true
  }

  export type BeneficioMinAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
    pontos?: true
    estado?: true
    id_categoria?: true
    created_at?: true
  }

  export type BeneficioMaxAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
    pontos?: true
    estado?: true
    id_categoria?: true
    created_at?: true
  }

  export type BeneficioCountAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
    pontos?: true
    estado?: true
    id_categoria?: true
    created_at?: true
    _all?: true
  }

  export type BeneficioAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Beneficio to aggregate.
     */
    where?: BeneficioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Beneficios to fetch.
     */
    orderBy?: BeneficioOrderByWithRelationInput | BeneficioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: BeneficioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Beneficios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Beneficios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Beneficios
    **/
    _count?: true | BeneficioCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: BeneficioAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: BeneficioSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: BeneficioMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: BeneficioMaxAggregateInputType
  }

  export type GetBeneficioAggregateType<T extends BeneficioAggregateArgs> = {
        [P in keyof T & keyof AggregateBeneficio]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateBeneficio[P]>
      : GetScalarType<T[P], AggregateBeneficio[P]>
  }




  export type BeneficioGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BeneficioWhereInput
    orderBy?: BeneficioOrderByWithAggregationInput | BeneficioOrderByWithAggregationInput[]
    by: BeneficioScalarFieldEnum[] | BeneficioScalarFieldEnum
    having?: BeneficioScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: BeneficioCountAggregateInputType | true
    _avg?: BeneficioAvgAggregateInputType
    _sum?: BeneficioSumAggregateInputType
    _min?: BeneficioMinAggregateInputType
    _max?: BeneficioMaxAggregateInputType
  }

  export type BeneficioGroupByOutputType = {
    id: string
    nome: string
    descricao: string
    pontos: number
    estado: boolean
    id_categoria: string
    created_at: Date
    _count: BeneficioCountAggregateOutputType | null
    _avg: BeneficioAvgAggregateOutputType | null
    _sum: BeneficioSumAggregateOutputType | null
    _min: BeneficioMinAggregateOutputType | null
    _max: BeneficioMaxAggregateOutputType | null
  }

  type GetBeneficioGroupByPayload<T extends BeneficioGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<BeneficioGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof BeneficioGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], BeneficioGroupByOutputType[P]>
            : GetScalarType<T[P], BeneficioGroupByOutputType[P]>
        }
      >
    >


  export type BeneficioSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    nome?: boolean
    descricao?: boolean
    pontos?: boolean
    estado?: boolean
    id_categoria?: boolean
    created_at?: boolean
    categoria?: boolean | CategoriaDefaultArgs<ExtArgs>
    referencias?: boolean | Beneficio$referenciasArgs<ExtArgs>
    _count?: boolean | BeneficioCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["beneficio"]>


  export type BeneficioSelectScalar = {
    id?: boolean
    nome?: boolean
    descricao?: boolean
    pontos?: boolean
    estado?: boolean
    id_categoria?: boolean
    created_at?: boolean
  }

  export type BeneficioInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    categoria?: boolean | CategoriaDefaultArgs<ExtArgs>
    referencias?: boolean | Beneficio$referenciasArgs<ExtArgs>
    _count?: boolean | BeneficioCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $BeneficioPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Beneficio"
    objects: {
      categoria: Prisma.$CategoriaPayload<ExtArgs>
      referencias: Prisma.$ReferenciaPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      nome: string
      descricao: string
      pontos: number
      estado: boolean
      id_categoria: string
      created_at: Date
    }, ExtArgs["result"]["beneficio"]>
    composites: {}
  }

  type BeneficioGetPayload<S extends boolean | null | undefined | BeneficioDefaultArgs> = $Result.GetResult<Prisma.$BeneficioPayload, S>

  type BeneficioCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<BeneficioFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: BeneficioCountAggregateInputType | true
    }

  export interface BeneficioDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Beneficio'], meta: { name: 'Beneficio' } }
    /**
     * Find zero or one Beneficio that matches the filter.
     * @param {BeneficioFindUniqueArgs} args - Arguments to find a Beneficio
     * @example
     * // Get one Beneficio
     * const beneficio = await prisma.beneficio.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends BeneficioFindUniqueArgs>(args: SelectSubset<T, BeneficioFindUniqueArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Beneficio that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {BeneficioFindUniqueOrThrowArgs} args - Arguments to find a Beneficio
     * @example
     * // Get one Beneficio
     * const beneficio = await prisma.beneficio.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends BeneficioFindUniqueOrThrowArgs>(args: SelectSubset<T, BeneficioFindUniqueOrThrowArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Beneficio that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioFindFirstArgs} args - Arguments to find a Beneficio
     * @example
     * // Get one Beneficio
     * const beneficio = await prisma.beneficio.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends BeneficioFindFirstArgs>(args?: SelectSubset<T, BeneficioFindFirstArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Beneficio that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioFindFirstOrThrowArgs} args - Arguments to find a Beneficio
     * @example
     * // Get one Beneficio
     * const beneficio = await prisma.beneficio.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends BeneficioFindFirstOrThrowArgs>(args?: SelectSubset<T, BeneficioFindFirstOrThrowArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Beneficios that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Beneficios
     * const beneficios = await prisma.beneficio.findMany()
     * 
     * // Get first 10 Beneficios
     * const beneficios = await prisma.beneficio.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const beneficioWithIdOnly = await prisma.beneficio.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends BeneficioFindManyArgs>(args?: SelectSubset<T, BeneficioFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Beneficio.
     * @param {BeneficioCreateArgs} args - Arguments to create a Beneficio.
     * @example
     * // Create one Beneficio
     * const Beneficio = await prisma.beneficio.create({
     *   data: {
     *     // ... data to create a Beneficio
     *   }
     * })
     * 
     */
    create<T extends BeneficioCreateArgs>(args: SelectSubset<T, BeneficioCreateArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Beneficios.
     * @param {BeneficioCreateManyArgs} args - Arguments to create many Beneficios.
     * @example
     * // Create many Beneficios
     * const beneficio = await prisma.beneficio.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends BeneficioCreateManyArgs>(args?: SelectSubset<T, BeneficioCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Beneficio.
     * @param {BeneficioDeleteArgs} args - Arguments to delete one Beneficio.
     * @example
     * // Delete one Beneficio
     * const Beneficio = await prisma.beneficio.delete({
     *   where: {
     *     // ... filter to delete one Beneficio
     *   }
     * })
     * 
     */
    delete<T extends BeneficioDeleteArgs>(args: SelectSubset<T, BeneficioDeleteArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Beneficio.
     * @param {BeneficioUpdateArgs} args - Arguments to update one Beneficio.
     * @example
     * // Update one Beneficio
     * const beneficio = await prisma.beneficio.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends BeneficioUpdateArgs>(args: SelectSubset<T, BeneficioUpdateArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Beneficios.
     * @param {BeneficioDeleteManyArgs} args - Arguments to filter Beneficios to delete.
     * @example
     * // Delete a few Beneficios
     * const { count } = await prisma.beneficio.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends BeneficioDeleteManyArgs>(args?: SelectSubset<T, BeneficioDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Beneficios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Beneficios
     * const beneficio = await prisma.beneficio.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends BeneficioUpdateManyArgs>(args: SelectSubset<T, BeneficioUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Beneficio.
     * @param {BeneficioUpsertArgs} args - Arguments to update or create a Beneficio.
     * @example
     * // Update or create a Beneficio
     * const beneficio = await prisma.beneficio.upsert({
     *   create: {
     *     // ... data to create a Beneficio
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Beneficio we want to update
     *   }
     * })
     */
    upsert<T extends BeneficioUpsertArgs>(args: SelectSubset<T, BeneficioUpsertArgs<ExtArgs>>): Prisma__BeneficioClient<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Beneficios.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioCountArgs} args - Arguments to filter Beneficios to count.
     * @example
     * // Count the number of Beneficios
     * const count = await prisma.beneficio.count({
     *   where: {
     *     // ... the filter for the Beneficios we want to count
     *   }
     * })
    **/
    count<T extends BeneficioCountArgs>(
      args?: Subset<T, BeneficioCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], BeneficioCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Beneficio.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends BeneficioAggregateArgs>(args: Subset<T, BeneficioAggregateArgs>): Prisma.PrismaPromise<GetBeneficioAggregateType<T>>

    /**
     * Group by Beneficio.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BeneficioGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends BeneficioGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: BeneficioGroupByArgs['orderBy'] }
        : { orderBy?: BeneficioGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, BeneficioGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetBeneficioGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Beneficio model
   */
  readonly fields: BeneficioFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Beneficio.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__BeneficioClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    categoria<T extends CategoriaDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CategoriaDefaultArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    referencias<T extends Beneficio$referenciasArgs<ExtArgs> = {}>(args?: Subset<T, Beneficio$referenciasArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Beneficio model
   */ 
  interface BeneficioFieldRefs {
    readonly id: FieldRef<"Beneficio", 'String'>
    readonly nome: FieldRef<"Beneficio", 'String'>
    readonly descricao: FieldRef<"Beneficio", 'String'>
    readonly pontos: FieldRef<"Beneficio", 'Int'>
    readonly estado: FieldRef<"Beneficio", 'Boolean'>
    readonly id_categoria: FieldRef<"Beneficio", 'String'>
    readonly created_at: FieldRef<"Beneficio", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Beneficio findUnique
   */
  export type BeneficioFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter, which Beneficio to fetch.
     */
    where: BeneficioWhereUniqueInput
  }

  /**
   * Beneficio findUniqueOrThrow
   */
  export type BeneficioFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter, which Beneficio to fetch.
     */
    where: BeneficioWhereUniqueInput
  }

  /**
   * Beneficio findFirst
   */
  export type BeneficioFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter, which Beneficio to fetch.
     */
    where?: BeneficioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Beneficios to fetch.
     */
    orderBy?: BeneficioOrderByWithRelationInput | BeneficioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Beneficios.
     */
    cursor?: BeneficioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Beneficios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Beneficios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Beneficios.
     */
    distinct?: BeneficioScalarFieldEnum | BeneficioScalarFieldEnum[]
  }

  /**
   * Beneficio findFirstOrThrow
   */
  export type BeneficioFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter, which Beneficio to fetch.
     */
    where?: BeneficioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Beneficios to fetch.
     */
    orderBy?: BeneficioOrderByWithRelationInput | BeneficioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Beneficios.
     */
    cursor?: BeneficioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Beneficios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Beneficios.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Beneficios.
     */
    distinct?: BeneficioScalarFieldEnum | BeneficioScalarFieldEnum[]
  }

  /**
   * Beneficio findMany
   */
  export type BeneficioFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter, which Beneficios to fetch.
     */
    where?: BeneficioWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Beneficios to fetch.
     */
    orderBy?: BeneficioOrderByWithRelationInput | BeneficioOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Beneficios.
     */
    cursor?: BeneficioWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Beneficios from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Beneficios.
     */
    skip?: number
    distinct?: BeneficioScalarFieldEnum | BeneficioScalarFieldEnum[]
  }

  /**
   * Beneficio create
   */
  export type BeneficioCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * The data needed to create a Beneficio.
     */
    data: XOR<BeneficioCreateInput, BeneficioUncheckedCreateInput>
  }

  /**
   * Beneficio createMany
   */
  export type BeneficioCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Beneficios.
     */
    data: BeneficioCreateManyInput | BeneficioCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Beneficio update
   */
  export type BeneficioUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * The data needed to update a Beneficio.
     */
    data: XOR<BeneficioUpdateInput, BeneficioUncheckedUpdateInput>
    /**
     * Choose, which Beneficio to update.
     */
    where: BeneficioWhereUniqueInput
  }

  /**
   * Beneficio updateMany
   */
  export type BeneficioUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Beneficios.
     */
    data: XOR<BeneficioUpdateManyMutationInput, BeneficioUncheckedUpdateManyInput>
    /**
     * Filter which Beneficios to update
     */
    where?: BeneficioWhereInput
  }

  /**
   * Beneficio upsert
   */
  export type BeneficioUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * The filter to search for the Beneficio to update in case it exists.
     */
    where: BeneficioWhereUniqueInput
    /**
     * In case the Beneficio found by the `where` argument doesn't exist, create a new Beneficio with this data.
     */
    create: XOR<BeneficioCreateInput, BeneficioUncheckedCreateInput>
    /**
     * In case the Beneficio was found with the provided `where` argument, update it with this data.
     */
    update: XOR<BeneficioUpdateInput, BeneficioUncheckedUpdateInput>
  }

  /**
   * Beneficio delete
   */
  export type BeneficioDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    /**
     * Filter which Beneficio to delete.
     */
    where: BeneficioWhereUniqueInput
  }

  /**
   * Beneficio deleteMany
   */
  export type BeneficioDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Beneficios to delete
     */
    where?: BeneficioWhereInput
  }

  /**
   * Beneficio.referencias
   */
  export type Beneficio$referenciasArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Referencia
     */
    select?: ReferenciaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferenciaInclude<ExtArgs> | null
    where?: ReferenciaWhereInput
    orderBy?: ReferenciaOrderByWithRelationInput | ReferenciaOrderByWithRelationInput[]
    cursor?: ReferenciaWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ReferenciaScalarFieldEnum | ReferenciaScalarFieldEnum[]
  }

  /**
   * Beneficio without action
   */
  export type BeneficioDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
  }


  /**
   * Model Categoria
   */

  export type AggregateCategoria = {
    _count: CategoriaCountAggregateOutputType | null
    _min: CategoriaMinAggregateOutputType | null
    _max: CategoriaMaxAggregateOutputType | null
  }

  export type CategoriaMinAggregateOutputType = {
    id: string | null
    nome: string | null
    descricao: string | null
  }

  export type CategoriaMaxAggregateOutputType = {
    id: string | null
    nome: string | null
    descricao: string | null
  }

  export type CategoriaCountAggregateOutputType = {
    id: number
    nome: number
    descricao: number
    _all: number
  }


  export type CategoriaMinAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
  }

  export type CategoriaMaxAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
  }

  export type CategoriaCountAggregateInputType = {
    id?: true
    nome?: true
    descricao?: true
    _all?: true
  }

  export type CategoriaAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categoria to aggregate.
     */
    where?: CategoriaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categorias to fetch.
     */
    orderBy?: CategoriaOrderByWithRelationInput | CategoriaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CategoriaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categorias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categorias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Categorias
    **/
    _count?: true | CategoriaCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CategoriaMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CategoriaMaxAggregateInputType
  }

  export type GetCategoriaAggregateType<T extends CategoriaAggregateArgs> = {
        [P in keyof T & keyof AggregateCategoria]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCategoria[P]>
      : GetScalarType<T[P], AggregateCategoria[P]>
  }




  export type CategoriaGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriaWhereInput
    orderBy?: CategoriaOrderByWithAggregationInput | CategoriaOrderByWithAggregationInput[]
    by: CategoriaScalarFieldEnum[] | CategoriaScalarFieldEnum
    having?: CategoriaScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CategoriaCountAggregateInputType | true
    _min?: CategoriaMinAggregateInputType
    _max?: CategoriaMaxAggregateInputType
  }

  export type CategoriaGroupByOutputType = {
    id: string
    nome: string
    descricao: string
    _count: CategoriaCountAggregateOutputType | null
    _min: CategoriaMinAggregateOutputType | null
    _max: CategoriaMaxAggregateOutputType | null
  }

  type GetCategoriaGroupByPayload<T extends CategoriaGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CategoriaGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CategoriaGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CategoriaGroupByOutputType[P]>
            : GetScalarType<T[P], CategoriaGroupByOutputType[P]>
        }
      >
    >


  export type CategoriaSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    nome?: boolean
    descricao?: boolean
    beneficios?: boolean | Categoria$beneficiosArgs<ExtArgs>
    _count?: boolean | CategoriaCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["categoria"]>


  export type CategoriaSelectScalar = {
    id?: boolean
    nome?: boolean
    descricao?: boolean
  }

  export type CategoriaInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    beneficios?: boolean | Categoria$beneficiosArgs<ExtArgs>
    _count?: boolean | CategoriaCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $CategoriaPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Categoria"
    objects: {
      beneficios: Prisma.$BeneficioPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      nome: string
      descricao: string
    }, ExtArgs["result"]["categoria"]>
    composites: {}
  }

  type CategoriaGetPayload<S extends boolean | null | undefined | CategoriaDefaultArgs> = $Result.GetResult<Prisma.$CategoriaPayload, S>

  type CategoriaCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CategoriaFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CategoriaCountAggregateInputType | true
    }

  export interface CategoriaDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Categoria'], meta: { name: 'Categoria' } }
    /**
     * Find zero or one Categoria that matches the filter.
     * @param {CategoriaFindUniqueArgs} args - Arguments to find a Categoria
     * @example
     * // Get one Categoria
     * const categoria = await prisma.categoria.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CategoriaFindUniqueArgs>(args: SelectSubset<T, CategoriaFindUniqueArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Categoria that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CategoriaFindUniqueOrThrowArgs} args - Arguments to find a Categoria
     * @example
     * // Get one Categoria
     * const categoria = await prisma.categoria.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CategoriaFindUniqueOrThrowArgs>(args: SelectSubset<T, CategoriaFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Categoria that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaFindFirstArgs} args - Arguments to find a Categoria
     * @example
     * // Get one Categoria
     * const categoria = await prisma.categoria.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CategoriaFindFirstArgs>(args?: SelectSubset<T, CategoriaFindFirstArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Categoria that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaFindFirstOrThrowArgs} args - Arguments to find a Categoria
     * @example
     * // Get one Categoria
     * const categoria = await prisma.categoria.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CategoriaFindFirstOrThrowArgs>(args?: SelectSubset<T, CategoriaFindFirstOrThrowArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Categorias that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Categorias
     * const categorias = await prisma.categoria.findMany()
     * 
     * // Get first 10 Categorias
     * const categorias = await prisma.categoria.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const categoriaWithIdOnly = await prisma.categoria.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CategoriaFindManyArgs>(args?: SelectSubset<T, CategoriaFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Categoria.
     * @param {CategoriaCreateArgs} args - Arguments to create a Categoria.
     * @example
     * // Create one Categoria
     * const Categoria = await prisma.categoria.create({
     *   data: {
     *     // ... data to create a Categoria
     *   }
     * })
     * 
     */
    create<T extends CategoriaCreateArgs>(args: SelectSubset<T, CategoriaCreateArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Categorias.
     * @param {CategoriaCreateManyArgs} args - Arguments to create many Categorias.
     * @example
     * // Create many Categorias
     * const categoria = await prisma.categoria.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CategoriaCreateManyArgs>(args?: SelectSubset<T, CategoriaCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Categoria.
     * @param {CategoriaDeleteArgs} args - Arguments to delete one Categoria.
     * @example
     * // Delete one Categoria
     * const Categoria = await prisma.categoria.delete({
     *   where: {
     *     // ... filter to delete one Categoria
     *   }
     * })
     * 
     */
    delete<T extends CategoriaDeleteArgs>(args: SelectSubset<T, CategoriaDeleteArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Categoria.
     * @param {CategoriaUpdateArgs} args - Arguments to update one Categoria.
     * @example
     * // Update one Categoria
     * const categoria = await prisma.categoria.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CategoriaUpdateArgs>(args: SelectSubset<T, CategoriaUpdateArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Categorias.
     * @param {CategoriaDeleteManyArgs} args - Arguments to filter Categorias to delete.
     * @example
     * // Delete a few Categorias
     * const { count } = await prisma.categoria.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CategoriaDeleteManyArgs>(args?: SelectSubset<T, CategoriaDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Categorias.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Categorias
     * const categoria = await prisma.categoria.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CategoriaUpdateManyArgs>(args: SelectSubset<T, CategoriaUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Categoria.
     * @param {CategoriaUpsertArgs} args - Arguments to update or create a Categoria.
     * @example
     * // Update or create a Categoria
     * const categoria = await prisma.categoria.upsert({
     *   create: {
     *     // ... data to create a Categoria
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Categoria we want to update
     *   }
     * })
     */
    upsert<T extends CategoriaUpsertArgs>(args: SelectSubset<T, CategoriaUpsertArgs<ExtArgs>>): Prisma__CategoriaClient<$Result.GetResult<Prisma.$CategoriaPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Categorias.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaCountArgs} args - Arguments to filter Categorias to count.
     * @example
     * // Count the number of Categorias
     * const count = await prisma.categoria.count({
     *   where: {
     *     // ... the filter for the Categorias we want to count
     *   }
     * })
    **/
    count<T extends CategoriaCountArgs>(
      args?: Subset<T, CategoriaCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CategoriaCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Categoria.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CategoriaAggregateArgs>(args: Subset<T, CategoriaAggregateArgs>): Prisma.PrismaPromise<GetCategoriaAggregateType<T>>

    /**
     * Group by Categoria.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriaGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CategoriaGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CategoriaGroupByArgs['orderBy'] }
        : { orderBy?: CategoriaGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CategoriaGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCategoriaGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Categoria model
   */
  readonly fields: CategoriaFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Categoria.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CategoriaClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    beneficios<T extends Categoria$beneficiosArgs<ExtArgs> = {}>(args?: Subset<T, Categoria$beneficiosArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BeneficioPayload<ExtArgs>, T, "findMany"> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Categoria model
   */ 
  interface CategoriaFieldRefs {
    readonly id: FieldRef<"Categoria", 'String'>
    readonly nome: FieldRef<"Categoria", 'String'>
    readonly descricao: FieldRef<"Categoria", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Categoria findUnique
   */
  export type CategoriaFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter, which Categoria to fetch.
     */
    where: CategoriaWhereUniqueInput
  }

  /**
   * Categoria findUniqueOrThrow
   */
  export type CategoriaFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter, which Categoria to fetch.
     */
    where: CategoriaWhereUniqueInput
  }

  /**
   * Categoria findFirst
   */
  export type CategoriaFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter, which Categoria to fetch.
     */
    where?: CategoriaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categorias to fetch.
     */
    orderBy?: CategoriaOrderByWithRelationInput | CategoriaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categorias.
     */
    cursor?: CategoriaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categorias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categorias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categorias.
     */
    distinct?: CategoriaScalarFieldEnum | CategoriaScalarFieldEnum[]
  }

  /**
   * Categoria findFirstOrThrow
   */
  export type CategoriaFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter, which Categoria to fetch.
     */
    where?: CategoriaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categorias to fetch.
     */
    orderBy?: CategoriaOrderByWithRelationInput | CategoriaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categorias.
     */
    cursor?: CategoriaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categorias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categorias.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categorias.
     */
    distinct?: CategoriaScalarFieldEnum | CategoriaScalarFieldEnum[]
  }

  /**
   * Categoria findMany
   */
  export type CategoriaFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter, which Categorias to fetch.
     */
    where?: CategoriaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categorias to fetch.
     */
    orderBy?: CategoriaOrderByWithRelationInput | CategoriaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Categorias.
     */
    cursor?: CategoriaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categorias from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categorias.
     */
    skip?: number
    distinct?: CategoriaScalarFieldEnum | CategoriaScalarFieldEnum[]
  }

  /**
   * Categoria create
   */
  export type CategoriaCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * The data needed to create a Categoria.
     */
    data: XOR<CategoriaCreateInput, CategoriaUncheckedCreateInput>
  }

  /**
   * Categoria createMany
   */
  export type CategoriaCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Categorias.
     */
    data: CategoriaCreateManyInput | CategoriaCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Categoria update
   */
  export type CategoriaUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * The data needed to update a Categoria.
     */
    data: XOR<CategoriaUpdateInput, CategoriaUncheckedUpdateInput>
    /**
     * Choose, which Categoria to update.
     */
    where: CategoriaWhereUniqueInput
  }

  /**
   * Categoria updateMany
   */
  export type CategoriaUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Categorias.
     */
    data: XOR<CategoriaUpdateManyMutationInput, CategoriaUncheckedUpdateManyInput>
    /**
     * Filter which Categorias to update
     */
    where?: CategoriaWhereInput
  }

  /**
   * Categoria upsert
   */
  export type CategoriaUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * The filter to search for the Categoria to update in case it exists.
     */
    where: CategoriaWhereUniqueInput
    /**
     * In case the Categoria found by the `where` argument doesn't exist, create a new Categoria with this data.
     */
    create: XOR<CategoriaCreateInput, CategoriaUncheckedCreateInput>
    /**
     * In case the Categoria was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CategoriaUpdateInput, CategoriaUncheckedUpdateInput>
  }

  /**
   * Categoria delete
   */
  export type CategoriaDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
    /**
     * Filter which Categoria to delete.
     */
    where: CategoriaWhereUniqueInput
  }

  /**
   * Categoria deleteMany
   */
  export type CategoriaDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categorias to delete
     */
    where?: CategoriaWhereInput
  }

  /**
   * Categoria.beneficios
   */
  export type Categoria$beneficiosArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Beneficio
     */
    select?: BeneficioSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BeneficioInclude<ExtArgs> | null
    where?: BeneficioWhereInput
    orderBy?: BeneficioOrderByWithRelationInput | BeneficioOrderByWithRelationInput[]
    cursor?: BeneficioWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BeneficioScalarFieldEnum | BeneficioScalarFieldEnum[]
  }

  /**
   * Categoria without action
   */
  export type CategoriaDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categoria
     */
    select?: CategoriaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriaInclude<ExtArgs> | null
  }


  /**
   * Model Troca
   */

  export type AggregateTroca = {
    _count: TrocaCountAggregateOutputType | null
    _min: TrocaMinAggregateOutputType | null
    _max: TrocaMaxAggregateOutputType | null
  }

  export type TrocaMinAggregateOutputType = {
    id: string | null
    id_referencia: string | null
    id_usuario: string | null
    email: string | null
    telefone: string | null
    data: Date | null
  }

  export type TrocaMaxAggregateOutputType = {
    id: string | null
    id_referencia: string | null
    id_usuario: string | null
    email: string | null
    telefone: string | null
    data: Date | null
  }

  export type TrocaCountAggregateOutputType = {
    id: number
    id_referencia: number
    id_usuario: number
    email: number
    telefone: number
    data: number
    _all: number
  }


  export type TrocaMinAggregateInputType = {
    id?: true
    id_referencia?: true
    id_usuario?: true
    email?: true
    telefone?: true
    data?: true
  }

  export type TrocaMaxAggregateInputType = {
    id?: true
    id_referencia?: true
    id_usuario?: true
    email?: true
    telefone?: true
    data?: true
  }

  export type TrocaCountAggregateInputType = {
    id?: true
    id_referencia?: true
    id_usuario?: true
    email?: true
    telefone?: true
    data?: true
    _all?: true
  }

  export type TrocaAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Troca to aggregate.
     */
    where?: TrocaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Trocas to fetch.
     */
    orderBy?: TrocaOrderByWithRelationInput | TrocaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TrocaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Trocas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Trocas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Trocas
    **/
    _count?: true | TrocaCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TrocaMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TrocaMaxAggregateInputType
  }

  export type GetTrocaAggregateType<T extends TrocaAggregateArgs> = {
        [P in keyof T & keyof AggregateTroca]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTroca[P]>
      : GetScalarType<T[P], AggregateTroca[P]>
  }




  export type TrocaGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TrocaWhereInput
    orderBy?: TrocaOrderByWithAggregationInput | TrocaOrderByWithAggregationInput[]
    by: TrocaScalarFieldEnum[] | TrocaScalarFieldEnum
    having?: TrocaScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TrocaCountAggregateInputType | true
    _min?: TrocaMinAggregateInputType
    _max?: TrocaMaxAggregateInputType
  }

  export type TrocaGroupByOutputType = {
    id: string
    id_referencia: string
    id_usuario: string
    email: string | null
    telefone: string | null
    data: Date
    _count: TrocaCountAggregateOutputType | null
    _min: TrocaMinAggregateOutputType | null
    _max: TrocaMaxAggregateOutputType | null
  }

  type GetTrocaGroupByPayload<T extends TrocaGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TrocaGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TrocaGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TrocaGroupByOutputType[P]>
            : GetScalarType<T[P], TrocaGroupByOutputType[P]>
        }
      >
    >


  export type TrocaSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    id_referencia?: boolean
    id_usuario?: boolean
    email?: boolean
    telefone?: boolean
    data?: boolean
    usuario?: boolean | UsuarioDefaultArgs<ExtArgs>
    referencia?: boolean | ReferenciaDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["troca"]>


  export type TrocaSelectScalar = {
    id?: boolean
    id_referencia?: boolean
    id_usuario?: boolean
    email?: boolean
    telefone?: boolean
    data?: boolean
  }

  export type TrocaInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usuario?: boolean | UsuarioDefaultArgs<ExtArgs>
    referencia?: boolean | ReferenciaDefaultArgs<ExtArgs>
  }

  export type $TrocaPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Troca"
    objects: {
      usuario: Prisma.$UsuarioPayload<ExtArgs>
      referencia: Prisma.$ReferenciaPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      id_referencia: string
      id_usuario: string
      email: string | null
      telefone: string | null
      data: Date
    }, ExtArgs["result"]["troca"]>
    composites: {}
  }

  type TrocaGetPayload<S extends boolean | null | undefined | TrocaDefaultArgs> = $Result.GetResult<Prisma.$TrocaPayload, S>

  type TrocaCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<TrocaFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: TrocaCountAggregateInputType | true
    }

  export interface TrocaDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Troca'], meta: { name: 'Troca' } }
    /**
     * Find zero or one Troca that matches the filter.
     * @param {TrocaFindUniqueArgs} args - Arguments to find a Troca
     * @example
     * // Get one Troca
     * const troca = await prisma.troca.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TrocaFindUniqueArgs>(args: SelectSubset<T, TrocaFindUniqueArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findUnique"> | null, null, ExtArgs>

    /**
     * Find one Troca that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {TrocaFindUniqueOrThrowArgs} args - Arguments to find a Troca
     * @example
     * // Get one Troca
     * const troca = await prisma.troca.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TrocaFindUniqueOrThrowArgs>(args: SelectSubset<T, TrocaFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findUniqueOrThrow">, never, ExtArgs>

    /**
     * Find the first Troca that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaFindFirstArgs} args - Arguments to find a Troca
     * @example
     * // Get one Troca
     * const troca = await prisma.troca.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TrocaFindFirstArgs>(args?: SelectSubset<T, TrocaFindFirstArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findFirst"> | null, null, ExtArgs>

    /**
     * Find the first Troca that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaFindFirstOrThrowArgs} args - Arguments to find a Troca
     * @example
     * // Get one Troca
     * const troca = await prisma.troca.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TrocaFindFirstOrThrowArgs>(args?: SelectSubset<T, TrocaFindFirstOrThrowArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findFirstOrThrow">, never, ExtArgs>

    /**
     * Find zero or more Trocas that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Trocas
     * const trocas = await prisma.troca.findMany()
     * 
     * // Get first 10 Trocas
     * const trocas = await prisma.troca.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const trocaWithIdOnly = await prisma.troca.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TrocaFindManyArgs>(args?: SelectSubset<T, TrocaFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "findMany">>

    /**
     * Create a Troca.
     * @param {TrocaCreateArgs} args - Arguments to create a Troca.
     * @example
     * // Create one Troca
     * const Troca = await prisma.troca.create({
     *   data: {
     *     // ... data to create a Troca
     *   }
     * })
     * 
     */
    create<T extends TrocaCreateArgs>(args: SelectSubset<T, TrocaCreateArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "create">, never, ExtArgs>

    /**
     * Create many Trocas.
     * @param {TrocaCreateManyArgs} args - Arguments to create many Trocas.
     * @example
     * // Create many Trocas
     * const troca = await prisma.troca.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TrocaCreateManyArgs>(args?: SelectSubset<T, TrocaCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Troca.
     * @param {TrocaDeleteArgs} args - Arguments to delete one Troca.
     * @example
     * // Delete one Troca
     * const Troca = await prisma.troca.delete({
     *   where: {
     *     // ... filter to delete one Troca
     *   }
     * })
     * 
     */
    delete<T extends TrocaDeleteArgs>(args: SelectSubset<T, TrocaDeleteArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "delete">, never, ExtArgs>

    /**
     * Update one Troca.
     * @param {TrocaUpdateArgs} args - Arguments to update one Troca.
     * @example
     * // Update one Troca
     * const troca = await prisma.troca.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TrocaUpdateArgs>(args: SelectSubset<T, TrocaUpdateArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "update">, never, ExtArgs>

    /**
     * Delete zero or more Trocas.
     * @param {TrocaDeleteManyArgs} args - Arguments to filter Trocas to delete.
     * @example
     * // Delete a few Trocas
     * const { count } = await prisma.troca.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TrocaDeleteManyArgs>(args?: SelectSubset<T, TrocaDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Trocas.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Trocas
     * const troca = await prisma.troca.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TrocaUpdateManyArgs>(args: SelectSubset<T, TrocaUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Troca.
     * @param {TrocaUpsertArgs} args - Arguments to update or create a Troca.
     * @example
     * // Update or create a Troca
     * const troca = await prisma.troca.upsert({
     *   create: {
     *     // ... data to create a Troca
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Troca we want to update
     *   }
     * })
     */
    upsert<T extends TrocaUpsertArgs>(args: SelectSubset<T, TrocaUpsertArgs<ExtArgs>>): Prisma__TrocaClient<$Result.GetResult<Prisma.$TrocaPayload<ExtArgs>, T, "upsert">, never, ExtArgs>


    /**
     * Count the number of Trocas.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaCountArgs} args - Arguments to filter Trocas to count.
     * @example
     * // Count the number of Trocas
     * const count = await prisma.troca.count({
     *   where: {
     *     // ... the filter for the Trocas we want to count
     *   }
     * })
    **/
    count<T extends TrocaCountArgs>(
      args?: Subset<T, TrocaCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TrocaCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Troca.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TrocaAggregateArgs>(args: Subset<T, TrocaAggregateArgs>): Prisma.PrismaPromise<GetTrocaAggregateType<T>>

    /**
     * Group by Troca.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrocaGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TrocaGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TrocaGroupByArgs['orderBy'] }
        : { orderBy?: TrocaGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TrocaGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTrocaGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Troca model
   */
  readonly fields: TrocaFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Troca.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TrocaClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    usuario<T extends UsuarioDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UsuarioDefaultArgs<ExtArgs>>): Prisma__UsuarioClient<$Result.GetResult<Prisma.$UsuarioPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    referencia<T extends ReferenciaDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ReferenciaDefaultArgs<ExtArgs>>): Prisma__ReferenciaClient<$Result.GetResult<Prisma.$ReferenciaPayload<ExtArgs>, T, "findUniqueOrThrow"> | Null, Null, ExtArgs>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Troca model
   */ 
  interface TrocaFieldRefs {
    readonly id: FieldRef<"Troca", 'String'>
    readonly id_referencia: FieldRef<"Troca", 'String'>
    readonly id_usuario: FieldRef<"Troca", 'String'>
    readonly email: FieldRef<"Troca", 'String'>
    readonly telefone: FieldRef<"Troca", 'String'>
    readonly data: FieldRef<"Troca", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Troca findUnique
   */
  export type TrocaFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter, which Troca to fetch.
     */
    where: TrocaWhereUniqueInput
  }

  /**
   * Troca findUniqueOrThrow
   */
  export type TrocaFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter, which Troca to fetch.
     */
    where: TrocaWhereUniqueInput
  }

  /**
   * Troca findFirst
   */
  export type TrocaFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter, which Troca to fetch.
     */
    where?: TrocaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Trocas to fetch.
     */
    orderBy?: TrocaOrderByWithRelationInput | TrocaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Trocas.
     */
    cursor?: TrocaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Trocas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Trocas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Trocas.
     */
    distinct?: TrocaScalarFieldEnum | TrocaScalarFieldEnum[]
  }

  /**
   * Troca findFirstOrThrow
   */
  export type TrocaFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter, which Troca to fetch.
     */
    where?: TrocaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Trocas to fetch.
     */
    orderBy?: TrocaOrderByWithRelationInput | TrocaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Trocas.
     */
    cursor?: TrocaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Trocas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Trocas.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Trocas.
     */
    distinct?: TrocaScalarFieldEnum | TrocaScalarFieldEnum[]
  }

  /**
   * Troca findMany
   */
  export type TrocaFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter, which Trocas to fetch.
     */
    where?: TrocaWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Trocas to fetch.
     */
    orderBy?: TrocaOrderByWithRelationInput | TrocaOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Trocas.
     */
    cursor?: TrocaWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Trocas from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Trocas.
     */
    skip?: number
    distinct?: TrocaScalarFieldEnum | TrocaScalarFieldEnum[]
  }

  /**
   * Troca create
   */
  export type TrocaCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * The data needed to create a Troca.
     */
    data: XOR<TrocaCreateInput, TrocaUncheckedCreateInput>
  }

  /**
   * Troca createMany
   */
  export type TrocaCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Trocas.
     */
    data: TrocaCreateManyInput | TrocaCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Troca update
   */
  export type TrocaUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * The data needed to update a Troca.
     */
    data: XOR<TrocaUpdateInput, TrocaUncheckedUpdateInput>
    /**
     * Choose, which Troca to update.
     */
    where: TrocaWhereUniqueInput
  }

  /**
   * Troca updateMany
   */
  export type TrocaUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Trocas.
     */
    data: XOR<TrocaUpdateManyMutationInput, TrocaUncheckedUpdateManyInput>
    /**
     * Filter which Trocas to update
     */
    where?: TrocaWhereInput
  }

  /**
   * Troca upsert
   */
  export type TrocaUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * The filter to search for the Troca to update in case it exists.
     */
    where: TrocaWhereUniqueInput
    /**
     * In case the Troca found by the `where` argument doesn't exist, create a new Troca with this data.
     */
    create: XOR<TrocaCreateInput, TrocaUncheckedCreateInput>
    /**
     * In case the Troca was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TrocaUpdateInput, TrocaUncheckedUpdateInput>
  }

  /**
   * Troca delete
   */
  export type TrocaDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
    /**
     * Filter which Troca to delete.
     */
    where: TrocaWhereUniqueInput
  }

  /**
   * Troca deleteMany
   */
  export type TrocaDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Trocas to delete
     */
    where?: TrocaWhereInput
  }

  /**
   * Troca without action
   */
  export type TrocaDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Troca
     */
    select?: TrocaSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrocaInclude<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const UsuarioScalarFieldEnum: {
    id: 'id',
    nome: 'nome',
    email: 'email',
    email_recuperacao: 'email_recuperacao',
    senha: 'senha',
    telefone: 'telefone',
    pontos: 'pontos',
    foto: 'foto',
    tipo: 'tipo'
  };

  export type UsuarioScalarFieldEnum = (typeof UsuarioScalarFieldEnum)[keyof typeof UsuarioScalarFieldEnum]


  export const CartaoScalarFieldEnum: {
    id: 'id',
    numero: 'numero',
    estado: 'estado'
  };

  export type CartaoScalarFieldEnum = (typeof CartaoScalarFieldEnum)[keyof typeof CartaoScalarFieldEnum]


  export const CartaoUsuarioScalarFieldEnum: {
    id: 'id',
    id_cartao: 'id_cartao',
    id_usuario: 'id_usuario',
    estado: 'estado'
  };

  export type CartaoUsuarioScalarFieldEnum = (typeof CartaoUsuarioScalarFieldEnum)[keyof typeof CartaoUsuarioScalarFieldEnum]


  export const ReferenciaScalarFieldEnum: {
    id: 'id',
    codigo: 'codigo',
    usado: 'usado',
    data: 'data',
    id_beneficio: 'id_beneficio'
  };

  export type ReferenciaScalarFieldEnum = (typeof ReferenciaScalarFieldEnum)[keyof typeof ReferenciaScalarFieldEnum]


  export const BeneficioScalarFieldEnum: {
    id: 'id',
    nome: 'nome',
    descricao: 'descricao',
    pontos: 'pontos',
    estado: 'estado',
    id_categoria: 'id_categoria',
    created_at: 'created_at'
  };

  export type BeneficioScalarFieldEnum = (typeof BeneficioScalarFieldEnum)[keyof typeof BeneficioScalarFieldEnum]


  export const CategoriaScalarFieldEnum: {
    id: 'id',
    nome: 'nome',
    descricao: 'descricao'
  };

  export type CategoriaScalarFieldEnum = (typeof CategoriaScalarFieldEnum)[keyof typeof CategoriaScalarFieldEnum]


  export const TrocaScalarFieldEnum: {
    id: 'id',
    id_referencia: 'id_referencia',
    id_usuario: 'id_usuario',
    email: 'email',
    telefone: 'telefone',
    data: 'data'
  };

  export type TrocaScalarFieldEnum = (typeof TrocaScalarFieldEnum)[keyof typeof TrocaScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  export const UsuarioOrderByRelevanceFieldEnum: {
    id: 'id',
    nome: 'nome',
    email: 'email',
    email_recuperacao: 'email_recuperacao',
    senha: 'senha',
    telefone: 'telefone',
    foto: 'foto',
    tipo: 'tipo'
  };

  export type UsuarioOrderByRelevanceFieldEnum = (typeof UsuarioOrderByRelevanceFieldEnum)[keyof typeof UsuarioOrderByRelevanceFieldEnum]


  export const CartaoOrderByRelevanceFieldEnum: {
    id: 'id',
    numero: 'numero'
  };

  export type CartaoOrderByRelevanceFieldEnum = (typeof CartaoOrderByRelevanceFieldEnum)[keyof typeof CartaoOrderByRelevanceFieldEnum]


  export const CartaoUsuarioOrderByRelevanceFieldEnum: {
    id: 'id',
    id_cartao: 'id_cartao',
    id_usuario: 'id_usuario'
  };

  export type CartaoUsuarioOrderByRelevanceFieldEnum = (typeof CartaoUsuarioOrderByRelevanceFieldEnum)[keyof typeof CartaoUsuarioOrderByRelevanceFieldEnum]


  export const ReferenciaOrderByRelevanceFieldEnum: {
    id: 'id',
    codigo: 'codigo',
    id_beneficio: 'id_beneficio'
  };

  export type ReferenciaOrderByRelevanceFieldEnum = (typeof ReferenciaOrderByRelevanceFieldEnum)[keyof typeof ReferenciaOrderByRelevanceFieldEnum]


  export const BeneficioOrderByRelevanceFieldEnum: {
    id: 'id',
    nome: 'nome',
    descricao: 'descricao',
    id_categoria: 'id_categoria'
  };

  export type BeneficioOrderByRelevanceFieldEnum = (typeof BeneficioOrderByRelevanceFieldEnum)[keyof typeof BeneficioOrderByRelevanceFieldEnum]


  export const CategoriaOrderByRelevanceFieldEnum: {
    id: 'id',
    nome: 'nome',
    descricao: 'descricao'
  };

  export type CategoriaOrderByRelevanceFieldEnum = (typeof CategoriaOrderByRelevanceFieldEnum)[keyof typeof CategoriaOrderByRelevanceFieldEnum]


  export const TrocaOrderByRelevanceFieldEnum: {
    id: 'id',
    id_referencia: 'id_referencia',
    id_usuario: 'id_usuario',
    email: 'email',
    telefone: 'telefone'
  };

  export type TrocaOrderByRelevanceFieldEnum = (typeof TrocaOrderByRelevanceFieldEnum)[keyof typeof TrocaOrderByRelevanceFieldEnum]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    
  /**
   * Deep Input Types
   */


  export type UsuarioWhereInput = {
    AND?: UsuarioWhereInput | UsuarioWhereInput[]
    OR?: UsuarioWhereInput[]
    NOT?: UsuarioWhereInput | UsuarioWhereInput[]
    id?: StringFilter<"Usuario"> | string
    nome?: StringFilter<"Usuario"> | string
    email?: StringFilter<"Usuario"> | string
    email_recuperacao?: StringNullableFilter<"Usuario"> | string | null
    senha?: StringFilter<"Usuario"> | string
    telefone?: StringFilter<"Usuario"> | string
    pontos?: IntFilter<"Usuario"> | number
    foto?: StringNullableFilter<"Usuario"> | string | null
    tipo?: StringFilter<"Usuario"> | string
    trocas?: TrocaListRelationFilter
    cartao_usuario?: XOR<CartaoUsuarioNullableScalarRelationFilter, CartaoUsuarioWhereInput> | null
  }

  export type UsuarioOrderByWithRelationInput = {
    id?: SortOrder
    nome?: SortOrder
    email?: SortOrder
    email_recuperacao?: SortOrderInput | SortOrder
    senha?: SortOrder
    telefone?: SortOrder
    pontos?: SortOrder
    foto?: SortOrderInput | SortOrder
    tipo?: SortOrder
    trocas?: TrocaOrderByRelationAggregateInput
    cartao_usuario?: CartaoUsuarioOrderByWithRelationInput
    _relevance?: UsuarioOrderByRelevanceInput
  }

  export type UsuarioWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    email?: string
    AND?: UsuarioWhereInput | UsuarioWhereInput[]
    OR?: UsuarioWhereInput[]
    NOT?: UsuarioWhereInput | UsuarioWhereInput[]
    nome?: StringFilter<"Usuario"> | string
    email_recuperacao?: StringNullableFilter<"Usuario"> | string | null
    senha?: StringFilter<"Usuario"> | string
    telefone?: StringFilter<"Usuario"> | string
    pontos?: IntFilter<"Usuario"> | number
    foto?: StringNullableFilter<"Usuario"> | string | null
    tipo?: StringFilter<"Usuario"> | string
    trocas?: TrocaListRelationFilter
    cartao_usuario?: XOR<CartaoUsuarioNullableScalarRelationFilter, CartaoUsuarioWhereInput> | null
  }, "id" | "email">

  export type UsuarioOrderByWithAggregationInput = {
    id?: SortOrder
    nome?: SortOrder
    email?: SortOrder
    email_recuperacao?: SortOrderInput | SortOrder
    senha?: SortOrder
    telefone?: SortOrder
    pontos?: SortOrder
    foto?: SortOrderInput | SortOrder
    tipo?: SortOrder
    _count?: UsuarioCountOrderByAggregateInput
    _avg?: UsuarioAvgOrderByAggregateInput
    _max?: UsuarioMaxOrderByAggregateInput
    _min?: UsuarioMinOrderByAggregateInput
    _sum?: UsuarioSumOrderByAggregateInput
  }

  export type UsuarioScalarWhereWithAggregatesInput = {
    AND?: UsuarioScalarWhereWithAggregatesInput | UsuarioScalarWhereWithAggregatesInput[]
    OR?: UsuarioScalarWhereWithAggregatesInput[]
    NOT?: UsuarioScalarWhereWithAggregatesInput | UsuarioScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Usuario"> | string
    nome?: StringWithAggregatesFilter<"Usuario"> | string
    email?: StringWithAggregatesFilter<"Usuario"> | string
    email_recuperacao?: StringNullableWithAggregatesFilter<"Usuario"> | string | null
    senha?: StringWithAggregatesFilter<"Usuario"> | string
    telefone?: StringWithAggregatesFilter<"Usuario"> | string
    pontos?: IntWithAggregatesFilter<"Usuario"> | number
    foto?: StringNullableWithAggregatesFilter<"Usuario"> | string | null
    tipo?: StringWithAggregatesFilter<"Usuario"> | string
  }

  export type CartaoWhereInput = {
    AND?: CartaoWhereInput | CartaoWhereInput[]
    OR?: CartaoWhereInput[]
    NOT?: CartaoWhereInput | CartaoWhereInput[]
    id?: StringFilter<"Cartao"> | string
    numero?: StringFilter<"Cartao"> | string
    estado?: BoolFilter<"Cartao"> | boolean
    cartao_usuario?: XOR<CartaoUsuarioNullableScalarRelationFilter, CartaoUsuarioWhereInput> | null
  }

  export type CartaoOrderByWithRelationInput = {
    id?: SortOrder
    numero?: SortOrder
    estado?: SortOrder
    cartao_usuario?: CartaoUsuarioOrderByWithRelationInput
    _relevance?: CartaoOrderByRelevanceInput
  }

  export type CartaoWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    numero?: string
    AND?: CartaoWhereInput | CartaoWhereInput[]
    OR?: CartaoWhereInput[]
    NOT?: CartaoWhereInput | CartaoWhereInput[]
    estado?: BoolFilter<"Cartao"> | boolean
    cartao_usuario?: XOR<CartaoUsuarioNullableScalarRelationFilter, CartaoUsuarioWhereInput> | null
  }, "id" | "numero">

  export type CartaoOrderByWithAggregationInput = {
    id?: SortOrder
    numero?: SortOrder
    estado?: SortOrder
    _count?: CartaoCountOrderByAggregateInput
    _max?: CartaoMaxOrderByAggregateInput
    _min?: CartaoMinOrderByAggregateInput
  }

  export type CartaoScalarWhereWithAggregatesInput = {
    AND?: CartaoScalarWhereWithAggregatesInput | CartaoScalarWhereWithAggregatesInput[]
    OR?: CartaoScalarWhereWithAggregatesInput[]
    NOT?: CartaoScalarWhereWithAggregatesInput | CartaoScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Cartao"> | string
    numero?: StringWithAggregatesFilter<"Cartao"> | string
    estado?: BoolWithAggregatesFilter<"Cartao"> | boolean
  }

  export type CartaoUsuarioWhereInput = {
    AND?: CartaoUsuarioWhereInput | CartaoUsuarioWhereInput[]
    OR?: CartaoUsuarioWhereInput[]
    NOT?: CartaoUsuarioWhereInput | CartaoUsuarioWhereInput[]
    id?: StringFilter<"CartaoUsuario"> | string
    id_cartao?: StringFilter<"CartaoUsuario"> | string
    id_usuario?: StringFilter<"CartaoUsuario"> | string
    estado?: BoolFilter<"CartaoUsuario"> | boolean
    cartao?: XOR<CartaoScalarRelationFilter, CartaoWhereInput>
    usuario?: XOR<UsuarioScalarRelationFilter, UsuarioWhereInput>
  }

  export type CartaoUsuarioOrderByWithRelationInput = {
    id?: SortOrder
    id_cartao?: SortOrder
    id_usuario?: SortOrder
    estado?: SortOrder
    cartao?: CartaoOrderByWithRelationInput
    usuario?: UsuarioOrderByWithRelationInput
    _relevance?: CartaoUsuarioOrderByRelevanceInput
  }

  export type CartaoUsuarioWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    id_cartao?: string
    id_usuario?: string
    AND?: CartaoUsuarioWhereInput | CartaoUsuarioWhereInput[]
    OR?: CartaoUsuarioWhereInput[]
    NOT?: CartaoUsuarioWhereInput | CartaoUsuarioWhereInput[]
    estado?: BoolFilter<"CartaoUsuario"> | boolean
    cartao?: XOR<CartaoScalarRelationFilter, CartaoWhereInput>
    usuario?: XOR<UsuarioScalarRelationFilter, UsuarioWhereInput>
  }, "id" | "id_cartao" | "id_usuario">

  export type CartaoUsuarioOrderByWithAggregationInput = {
    id?: SortOrder
    id_cartao?: SortOrder
    id_usuario?: SortOrder
    estado?: SortOrder
    _count?: CartaoUsuarioCountOrderByAggregateInput
    _max?: CartaoUsuarioMaxOrderByAggregateInput
    _min?: CartaoUsuarioMinOrderByAggregateInput
  }

  export type CartaoUsuarioScalarWhereWithAggregatesInput = {
    AND?: CartaoUsuarioScalarWhereWithAggregatesInput | CartaoUsuarioScalarWhereWithAggregatesInput[]
    OR?: CartaoUsuarioScalarWhereWithAggregatesInput[]
    NOT?: CartaoUsuarioScalarWhereWithAggregatesInput | CartaoUsuarioScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"CartaoUsuario"> | string
    id_cartao?: StringWithAggregatesFilter<"CartaoUsuario"> | string
    id_usuario?: StringWithAggregatesFilter<"CartaoUsuario"> | string
    estado?: BoolWithAggregatesFilter<"CartaoUsuario"> | boolean
  }

  export type ReferenciaWhereInput = {
    AND?: ReferenciaWhereInput | ReferenciaWhereInput[]
    OR?: ReferenciaWhereInput[]
    NOT?: ReferenciaWhereInput | ReferenciaWhereInput[]
    id?: StringFilter<"Referencia"> | string
    codigo?: StringFilter<"Referencia"> | string
    usado?: BoolFilter<"Referencia"> | boolean
    data?: DateTimeFilter<"Referencia"> | Date | string
    id_beneficio?: StringFilter<"Referencia"> | string
    beneficio?: XOR<BeneficioScalarRelationFilter, BeneficioWhereInput>
    troca?: XOR<TrocaNullableScalarRelationFilter, TrocaWhereInput> | null
  }

  export type ReferenciaOrderByWithRelationInput = {
    id?: SortOrder
    codigo?: SortOrder
    usado?: SortOrder
    data?: SortOrder
    id_beneficio?: SortOrder
    beneficio?: BeneficioOrderByWithRelationInput
    troca?: TrocaOrderByWithRelationInput
    _relevance?: ReferenciaOrderByRelevanceInput
  }

  export type ReferenciaWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    codigo?: string
    AND?: ReferenciaWhereInput | ReferenciaWhereInput[]
    OR?: ReferenciaWhereInput[]
    NOT?: ReferenciaWhereInput | ReferenciaWhereInput[]
    usado?: BoolFilter<"Referencia"> | boolean
    data?: DateTimeFilter<"Referencia"> | Date | string
    id_beneficio?: StringFilter<"Referencia"> | string
    beneficio?: XOR<BeneficioScalarRelationFilter, BeneficioWhereInput>
    troca?: XOR<TrocaNullableScalarRelationFilter, TrocaWhereInput> | null
  }, "id" | "codigo">

  export type ReferenciaOrderByWithAggregationInput = {
    id?: SortOrder
    codigo?: SortOrder
    usado?: SortOrder
    data?: SortOrder
    id_beneficio?: SortOrder
    _count?: ReferenciaCountOrderByAggregateInput
    _max?: ReferenciaMaxOrderByAggregateInput
    _min?: ReferenciaMinOrderByAggregateInput
  }

  export type ReferenciaScalarWhereWithAggregatesInput = {
    AND?: ReferenciaScalarWhereWithAggregatesInput | ReferenciaScalarWhereWithAggregatesInput[]
    OR?: ReferenciaScalarWhereWithAggregatesInput[]
    NOT?: ReferenciaScalarWhereWithAggregatesInput | ReferenciaScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Referencia"> | string
    codigo?: StringWithAggregatesFilter<"Referencia"> | string
    usado?: BoolWithAggregatesFilter<"Referencia"> | boolean
    data?: DateTimeWithAggregatesFilter<"Referencia"> | Date | string
    id_beneficio?: StringWithAggregatesFilter<"Referencia"> | string
  }

  export type BeneficioWhereInput = {
    AND?: BeneficioWhereInput | BeneficioWhereInput[]
    OR?: BeneficioWhereInput[]
    NOT?: BeneficioWhereInput | BeneficioWhereInput[]
    id?: StringFilter<"Beneficio"> | string
    nome?: StringFilter<"Beneficio"> | string
    descricao?: StringFilter<"Beneficio"> | string
    pontos?: IntFilter<"Beneficio"> | number
    estado?: BoolFilter<"Beneficio"> | boolean
    id_categoria?: StringFilter<"Beneficio"> | string
    created_at?: DateTimeFilter<"Beneficio"> | Date | string
    categoria?: XOR<CategoriaScalarRelationFilter, CategoriaWhereInput>
    referencias?: ReferenciaListRelationFilter
  }

  export type BeneficioOrderByWithRelationInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    pontos?: SortOrder
    estado?: SortOrder
    id_categoria?: SortOrder
    created_at?: SortOrder
    categoria?: CategoriaOrderByWithRelationInput
    referencias?: ReferenciaOrderByRelationAggregateInput
    _relevance?: BeneficioOrderByRelevanceInput
  }

  export type BeneficioWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    AND?: BeneficioWhereInput | BeneficioWhereInput[]
    OR?: BeneficioWhereInput[]
    NOT?: BeneficioWhereInput | BeneficioWhereInput[]
    nome?: StringFilter<"Beneficio"> | string
    descricao?: StringFilter<"Beneficio"> | string
    pontos?: IntFilter<"Beneficio"> | number
    estado?: BoolFilter<"Beneficio"> | boolean
    id_categoria?: StringFilter<"Beneficio"> | string
    created_at?: DateTimeFilter<"Beneficio"> | Date | string
    categoria?: XOR<CategoriaScalarRelationFilter, CategoriaWhereInput>
    referencias?: ReferenciaListRelationFilter
  }, "id">

  export type BeneficioOrderByWithAggregationInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    pontos?: SortOrder
    estado?: SortOrder
    id_categoria?: SortOrder
    created_at?: SortOrder
    _count?: BeneficioCountOrderByAggregateInput
    _avg?: BeneficioAvgOrderByAggregateInput
    _max?: BeneficioMaxOrderByAggregateInput
    _min?: BeneficioMinOrderByAggregateInput
    _sum?: BeneficioSumOrderByAggregateInput
  }

  export type BeneficioScalarWhereWithAggregatesInput = {
    AND?: BeneficioScalarWhereWithAggregatesInput | BeneficioScalarWhereWithAggregatesInput[]
    OR?: BeneficioScalarWhereWithAggregatesInput[]
    NOT?: BeneficioScalarWhereWithAggregatesInput | BeneficioScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Beneficio"> | string
    nome?: StringWithAggregatesFilter<"Beneficio"> | string
    descricao?: StringWithAggregatesFilter<"Beneficio"> | string
    pontos?: IntWithAggregatesFilter<"Beneficio"> | number
    estado?: BoolWithAggregatesFilter<"Beneficio"> | boolean
    id_categoria?: StringWithAggregatesFilter<"Beneficio"> | string
    created_at?: DateTimeWithAggregatesFilter<"Beneficio"> | Date | string
  }

  export type CategoriaWhereInput = {
    AND?: CategoriaWhereInput | CategoriaWhereInput[]
    OR?: CategoriaWhereInput[]
    NOT?: CategoriaWhereInput | CategoriaWhereInput[]
    id?: StringFilter<"Categoria"> | string
    nome?: StringFilter<"Categoria"> | string
    descricao?: StringFilter<"Categoria"> | string
    beneficios?: BeneficioListRelationFilter
  }

  export type CategoriaOrderByWithRelationInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    beneficios?: BeneficioOrderByRelationAggregateInput
    _relevance?: CategoriaOrderByRelevanceInput
  }

  export type CategoriaWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    nome?: string
    AND?: CategoriaWhereInput | CategoriaWhereInput[]
    OR?: CategoriaWhereInput[]
    NOT?: CategoriaWhereInput | CategoriaWhereInput[]
    descricao?: StringFilter<"Categoria"> | string
    beneficios?: BeneficioListRelationFilter
  }, "id" | "nome">

  export type CategoriaOrderByWithAggregationInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    _count?: CategoriaCountOrderByAggregateInput
    _max?: CategoriaMaxOrderByAggregateInput
    _min?: CategoriaMinOrderByAggregateInput
  }

  export type CategoriaScalarWhereWithAggregatesInput = {
    AND?: CategoriaScalarWhereWithAggregatesInput | CategoriaScalarWhereWithAggregatesInput[]
    OR?: CategoriaScalarWhereWithAggregatesInput[]
    NOT?: CategoriaScalarWhereWithAggregatesInput | CategoriaScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Categoria"> | string
    nome?: StringWithAggregatesFilter<"Categoria"> | string
    descricao?: StringWithAggregatesFilter<"Categoria"> | string
  }

  export type TrocaWhereInput = {
    AND?: TrocaWhereInput | TrocaWhereInput[]
    OR?: TrocaWhereInput[]
    NOT?: TrocaWhereInput | TrocaWhereInput[]
    id?: StringFilter<"Troca"> | string
    id_referencia?: StringFilter<"Troca"> | string
    id_usuario?: StringFilter<"Troca"> | string
    email?: StringNullableFilter<"Troca"> | string | null
    telefone?: StringNullableFilter<"Troca"> | string | null
    data?: DateTimeFilter<"Troca"> | Date | string
    usuario?: XOR<UsuarioScalarRelationFilter, UsuarioWhereInput>
    referencia?: XOR<ReferenciaScalarRelationFilter, ReferenciaWhereInput>
  }

  export type TrocaOrderByWithRelationInput = {
    id?: SortOrder
    id_referencia?: SortOrder
    id_usuario?: SortOrder
    email?: SortOrderInput | SortOrder
    telefone?: SortOrderInput | SortOrder
    data?: SortOrder
    usuario?: UsuarioOrderByWithRelationInput
    referencia?: ReferenciaOrderByWithRelationInput
    _relevance?: TrocaOrderByRelevanceInput
  }

  export type TrocaWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    id_referencia?: string
    AND?: TrocaWhereInput | TrocaWhereInput[]
    OR?: TrocaWhereInput[]
    NOT?: TrocaWhereInput | TrocaWhereInput[]
    id_usuario?: StringFilter<"Troca"> | string
    email?: StringNullableFilter<"Troca"> | string | null
    telefone?: StringNullableFilter<"Troca"> | string | null
    data?: DateTimeFilter<"Troca"> | Date | string
    usuario?: XOR<UsuarioScalarRelationFilter, UsuarioWhereInput>
    referencia?: XOR<ReferenciaScalarRelationFilter, ReferenciaWhereInput>
  }, "id" | "id_referencia">

  export type TrocaOrderByWithAggregationInput = {
    id?: SortOrder
    id_referencia?: SortOrder
    id_usuario?: SortOrder
    email?: SortOrderInput | SortOrder
    telefone?: SortOrderInput | SortOrder
    data?: SortOrder
    _count?: TrocaCountOrderByAggregateInput
    _max?: TrocaMaxOrderByAggregateInput
    _min?: TrocaMinOrderByAggregateInput
  }

  export type TrocaScalarWhereWithAggregatesInput = {
    AND?: TrocaScalarWhereWithAggregatesInput | TrocaScalarWhereWithAggregatesInput[]
    OR?: TrocaScalarWhereWithAggregatesInput[]
    NOT?: TrocaScalarWhereWithAggregatesInput | TrocaScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"Troca"> | string
    id_referencia?: StringWithAggregatesFilter<"Troca"> | string
    id_usuario?: StringWithAggregatesFilter<"Troca"> | string
    email?: StringNullableWithAggregatesFilter<"Troca"> | string | null
    telefone?: StringNullableWithAggregatesFilter<"Troca"> | string | null
    data?: DateTimeWithAggregatesFilter<"Troca"> | Date | string
  }

  export type UsuarioCreateInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    trocas?: TrocaCreateNestedManyWithoutUsuarioInput
    cartao_usuario?: CartaoUsuarioCreateNestedOneWithoutUsuarioInput
  }

  export type UsuarioUncheckedCreateInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    trocas?: TrocaUncheckedCreateNestedManyWithoutUsuarioInput
    cartao_usuario?: CartaoUsuarioUncheckedCreateNestedOneWithoutUsuarioInput
  }

  export type UsuarioUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    trocas?: TrocaUpdateManyWithoutUsuarioNestedInput
    cartao_usuario?: CartaoUsuarioUpdateOneWithoutUsuarioNestedInput
  }

  export type UsuarioUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    trocas?: TrocaUncheckedUpdateManyWithoutUsuarioNestedInput
    cartao_usuario?: CartaoUsuarioUncheckedUpdateOneWithoutUsuarioNestedInput
  }

  export type UsuarioCreateManyInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
  }

  export type UsuarioUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
  }

  export type UsuarioUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
  }

  export type CartaoCreateInput = {
    id?: string
    numero: string
    estado?: boolean
    cartao_usuario?: CartaoUsuarioCreateNestedOneWithoutCartaoInput
  }

  export type CartaoUncheckedCreateInput = {
    id?: string
    numero: string
    estado?: boolean
    cartao_usuario?: CartaoUsuarioUncheckedCreateNestedOneWithoutCartaoInput
  }

  export type CartaoUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
    cartao_usuario?: CartaoUsuarioUpdateOneWithoutCartaoNestedInput
  }

  export type CartaoUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
    cartao_usuario?: CartaoUsuarioUncheckedUpdateOneWithoutCartaoNestedInput
  }

  export type CartaoCreateManyInput = {
    id?: string
    numero: string
    estado?: boolean
  }

  export type CartaoUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUsuarioCreateInput = {
    id?: string
    estado?: boolean
    cartao: CartaoCreateNestedOneWithoutCartao_usuarioInput
    usuario: UsuarioCreateNestedOneWithoutCartao_usuarioInput
  }

  export type CartaoUsuarioUncheckedCreateInput = {
    id?: string
    id_cartao: string
    id_usuario: string
    estado?: boolean
  }

  export type CartaoUsuarioUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
    cartao?: CartaoUpdateOneRequiredWithoutCartao_usuarioNestedInput
    usuario?: UsuarioUpdateOneRequiredWithoutCartao_usuarioNestedInput
  }

  export type CartaoUsuarioUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_cartao?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUsuarioCreateManyInput = {
    id?: string
    id_cartao: string
    id_usuario: string
    estado?: boolean
  }

  export type CartaoUsuarioUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUsuarioUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_cartao?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type ReferenciaCreateInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    beneficio: BeneficioCreateNestedOneWithoutReferenciasInput
    troca?: TrocaCreateNestedOneWithoutReferenciaInput
  }

  export type ReferenciaUncheckedCreateInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    id_beneficio: string
    troca?: TrocaUncheckedCreateNestedOneWithoutReferenciaInput
  }

  export type ReferenciaUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    beneficio?: BeneficioUpdateOneRequiredWithoutReferenciasNestedInput
    troca?: TrocaUpdateOneWithoutReferenciaNestedInput
  }

  export type ReferenciaUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    id_beneficio?: StringFieldUpdateOperationsInput | string
    troca?: TrocaUncheckedUpdateOneWithoutReferenciaNestedInput
  }

  export type ReferenciaCreateManyInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    id_beneficio: string
  }

  export type ReferenciaUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ReferenciaUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    id_beneficio?: StringFieldUpdateOperationsInput | string
  }

  export type BeneficioCreateInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    created_at?: Date | string
    categoria: CategoriaCreateNestedOneWithoutBeneficiosInput
    referencias?: ReferenciaCreateNestedManyWithoutBeneficioInput
  }

  export type BeneficioUncheckedCreateInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    id_categoria: string
    created_at?: Date | string
    referencias?: ReferenciaUncheckedCreateNestedManyWithoutBeneficioInput
  }

  export type BeneficioUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    categoria?: CategoriaUpdateOneRequiredWithoutBeneficiosNestedInput
    referencias?: ReferenciaUpdateManyWithoutBeneficioNestedInput
  }

  export type BeneficioUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    id_categoria?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    referencias?: ReferenciaUncheckedUpdateManyWithoutBeneficioNestedInput
  }

  export type BeneficioCreateManyInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    id_categoria: string
    created_at?: Date | string
  }

  export type BeneficioUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type BeneficioUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    id_categoria?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type CategoriaCreateInput = {
    id?: string
    nome: string
    descricao: string
    beneficios?: BeneficioCreateNestedManyWithoutCategoriaInput
  }

  export type CategoriaUncheckedCreateInput = {
    id?: string
    nome: string
    descricao: string
    beneficios?: BeneficioUncheckedCreateNestedManyWithoutCategoriaInput
  }

  export type CategoriaUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    beneficios?: BeneficioUpdateManyWithoutCategoriaNestedInput
  }

  export type CategoriaUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    beneficios?: BeneficioUncheckedUpdateManyWithoutCategoriaNestedInput
  }

  export type CategoriaCreateManyInput = {
    id?: string
    nome: string
    descricao: string
  }

  export type CategoriaUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
  }

  export type CategoriaUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
  }

  export type TrocaCreateInput = {
    id?: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
    usuario: UsuarioCreateNestedOneWithoutTrocasInput
    referencia: ReferenciaCreateNestedOneWithoutTrocaInput
  }

  export type TrocaUncheckedCreateInput = {
    id?: string
    id_referencia: string
    id_usuario: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
  }

  export type TrocaUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    usuario?: UsuarioUpdateOneRequiredWithoutTrocasNestedInput
    referencia?: ReferenciaUpdateOneRequiredWithoutTrocaNestedInput
  }

  export type TrocaUncheckedUpdateInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_referencia?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TrocaCreateManyInput = {
    id?: string
    id_referencia: string
    id_usuario: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
  }

  export type TrocaUpdateManyMutationInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TrocaUncheckedUpdateManyInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_referencia?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type TrocaListRelationFilter = {
    every?: TrocaWhereInput
    some?: TrocaWhereInput
    none?: TrocaWhereInput
  }

  export type CartaoUsuarioNullableScalarRelationFilter = {
    is?: CartaoUsuarioWhereInput | null
    isNot?: CartaoUsuarioWhereInput | null
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type TrocaOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UsuarioOrderByRelevanceInput = {
    fields: UsuarioOrderByRelevanceFieldEnum | UsuarioOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type UsuarioCountOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    email?: SortOrder
    email_recuperacao?: SortOrder
    senha?: SortOrder
    telefone?: SortOrder
    pontos?: SortOrder
    foto?: SortOrder
    tipo?: SortOrder
  }

  export type UsuarioAvgOrderByAggregateInput = {
    pontos?: SortOrder
  }

  export type UsuarioMaxOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    email?: SortOrder
    email_recuperacao?: SortOrder
    senha?: SortOrder
    telefone?: SortOrder
    pontos?: SortOrder
    foto?: SortOrder
    tipo?: SortOrder
  }

  export type UsuarioMinOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    email?: SortOrder
    email_recuperacao?: SortOrder
    senha?: SortOrder
    telefone?: SortOrder
    pontos?: SortOrder
    foto?: SortOrder
    tipo?: SortOrder
  }

  export type UsuarioSumOrderByAggregateInput = {
    pontos?: SortOrder
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type BoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type CartaoOrderByRelevanceInput = {
    fields: CartaoOrderByRelevanceFieldEnum | CartaoOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type CartaoCountOrderByAggregateInput = {
    id?: SortOrder
    numero?: SortOrder
    estado?: SortOrder
  }

  export type CartaoMaxOrderByAggregateInput = {
    id?: SortOrder
    numero?: SortOrder
    estado?: SortOrder
  }

  export type CartaoMinOrderByAggregateInput = {
    id?: SortOrder
    numero?: SortOrder
    estado?: SortOrder
  }

  export type BoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type CartaoScalarRelationFilter = {
    is?: CartaoWhereInput
    isNot?: CartaoWhereInput
  }

  export type UsuarioScalarRelationFilter = {
    is?: UsuarioWhereInput
    isNot?: UsuarioWhereInput
  }

  export type CartaoUsuarioOrderByRelevanceInput = {
    fields: CartaoUsuarioOrderByRelevanceFieldEnum | CartaoUsuarioOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type CartaoUsuarioCountOrderByAggregateInput = {
    id?: SortOrder
    id_cartao?: SortOrder
    id_usuario?: SortOrder
    estado?: SortOrder
  }

  export type CartaoUsuarioMaxOrderByAggregateInput = {
    id?: SortOrder
    id_cartao?: SortOrder
    id_usuario?: SortOrder
    estado?: SortOrder
  }

  export type CartaoUsuarioMinOrderByAggregateInput = {
    id?: SortOrder
    id_cartao?: SortOrder
    id_usuario?: SortOrder
    estado?: SortOrder
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type BeneficioScalarRelationFilter = {
    is?: BeneficioWhereInput
    isNot?: BeneficioWhereInput
  }

  export type TrocaNullableScalarRelationFilter = {
    is?: TrocaWhereInput | null
    isNot?: TrocaWhereInput | null
  }

  export type ReferenciaOrderByRelevanceInput = {
    fields: ReferenciaOrderByRelevanceFieldEnum | ReferenciaOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type ReferenciaCountOrderByAggregateInput = {
    id?: SortOrder
    codigo?: SortOrder
    usado?: SortOrder
    data?: SortOrder
    id_beneficio?: SortOrder
  }

  export type ReferenciaMaxOrderByAggregateInput = {
    id?: SortOrder
    codigo?: SortOrder
    usado?: SortOrder
    data?: SortOrder
    id_beneficio?: SortOrder
  }

  export type ReferenciaMinOrderByAggregateInput = {
    id?: SortOrder
    codigo?: SortOrder
    usado?: SortOrder
    data?: SortOrder
    id_beneficio?: SortOrder
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type CategoriaScalarRelationFilter = {
    is?: CategoriaWhereInput
    isNot?: CategoriaWhereInput
  }

  export type ReferenciaListRelationFilter = {
    every?: ReferenciaWhereInput
    some?: ReferenciaWhereInput
    none?: ReferenciaWhereInput
  }

  export type ReferenciaOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type BeneficioOrderByRelevanceInput = {
    fields: BeneficioOrderByRelevanceFieldEnum | BeneficioOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type BeneficioCountOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    pontos?: SortOrder
    estado?: SortOrder
    id_categoria?: SortOrder
    created_at?: SortOrder
  }

  export type BeneficioAvgOrderByAggregateInput = {
    pontos?: SortOrder
  }

  export type BeneficioMaxOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    pontos?: SortOrder
    estado?: SortOrder
    id_categoria?: SortOrder
    created_at?: SortOrder
  }

  export type BeneficioMinOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
    pontos?: SortOrder
    estado?: SortOrder
    id_categoria?: SortOrder
    created_at?: SortOrder
  }

  export type BeneficioSumOrderByAggregateInput = {
    pontos?: SortOrder
  }

  export type BeneficioListRelationFilter = {
    every?: BeneficioWhereInput
    some?: BeneficioWhereInput
    none?: BeneficioWhereInput
  }

  export type BeneficioOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type CategoriaOrderByRelevanceInput = {
    fields: CategoriaOrderByRelevanceFieldEnum | CategoriaOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type CategoriaCountOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
  }

  export type CategoriaMaxOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
  }

  export type CategoriaMinOrderByAggregateInput = {
    id?: SortOrder
    nome?: SortOrder
    descricao?: SortOrder
  }

  export type ReferenciaScalarRelationFilter = {
    is?: ReferenciaWhereInput
    isNot?: ReferenciaWhereInput
  }

  export type TrocaOrderByRelevanceInput = {
    fields: TrocaOrderByRelevanceFieldEnum | TrocaOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type TrocaCountOrderByAggregateInput = {
    id?: SortOrder
    id_referencia?: SortOrder
    id_usuario?: SortOrder
    email?: SortOrder
    telefone?: SortOrder
    data?: SortOrder
  }

  export type TrocaMaxOrderByAggregateInput = {
    id?: SortOrder
    id_referencia?: SortOrder
    id_usuario?: SortOrder
    email?: SortOrder
    telefone?: SortOrder
    data?: SortOrder
  }

  export type TrocaMinOrderByAggregateInput = {
    id?: SortOrder
    id_referencia?: SortOrder
    id_usuario?: SortOrder
    email?: SortOrder
    telefone?: SortOrder
    data?: SortOrder
  }

  export type TrocaCreateNestedManyWithoutUsuarioInput = {
    create?: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput> | TrocaCreateWithoutUsuarioInput[] | TrocaUncheckedCreateWithoutUsuarioInput[]
    connectOrCreate?: TrocaCreateOrConnectWithoutUsuarioInput | TrocaCreateOrConnectWithoutUsuarioInput[]
    createMany?: TrocaCreateManyUsuarioInputEnvelope
    connect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
  }

  export type CartaoUsuarioCreateNestedOneWithoutUsuarioInput = {
    create?: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutUsuarioInput
    connect?: CartaoUsuarioWhereUniqueInput
  }

  export type TrocaUncheckedCreateNestedManyWithoutUsuarioInput = {
    create?: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput> | TrocaCreateWithoutUsuarioInput[] | TrocaUncheckedCreateWithoutUsuarioInput[]
    connectOrCreate?: TrocaCreateOrConnectWithoutUsuarioInput | TrocaCreateOrConnectWithoutUsuarioInput[]
    createMany?: TrocaCreateManyUsuarioInputEnvelope
    connect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
  }

  export type CartaoUsuarioUncheckedCreateNestedOneWithoutUsuarioInput = {
    create?: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutUsuarioInput
    connect?: CartaoUsuarioWhereUniqueInput
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type TrocaUpdateManyWithoutUsuarioNestedInput = {
    create?: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput> | TrocaCreateWithoutUsuarioInput[] | TrocaUncheckedCreateWithoutUsuarioInput[]
    connectOrCreate?: TrocaCreateOrConnectWithoutUsuarioInput | TrocaCreateOrConnectWithoutUsuarioInput[]
    upsert?: TrocaUpsertWithWhereUniqueWithoutUsuarioInput | TrocaUpsertWithWhereUniqueWithoutUsuarioInput[]
    createMany?: TrocaCreateManyUsuarioInputEnvelope
    set?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    disconnect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    delete?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    connect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    update?: TrocaUpdateWithWhereUniqueWithoutUsuarioInput | TrocaUpdateWithWhereUniqueWithoutUsuarioInput[]
    updateMany?: TrocaUpdateManyWithWhereWithoutUsuarioInput | TrocaUpdateManyWithWhereWithoutUsuarioInput[]
    deleteMany?: TrocaScalarWhereInput | TrocaScalarWhereInput[]
  }

  export type CartaoUsuarioUpdateOneWithoutUsuarioNestedInput = {
    create?: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutUsuarioInput
    upsert?: CartaoUsuarioUpsertWithoutUsuarioInput
    disconnect?: CartaoUsuarioWhereInput | boolean
    delete?: CartaoUsuarioWhereInput | boolean
    connect?: CartaoUsuarioWhereUniqueInput
    update?: XOR<XOR<CartaoUsuarioUpdateToOneWithWhereWithoutUsuarioInput, CartaoUsuarioUpdateWithoutUsuarioInput>, CartaoUsuarioUncheckedUpdateWithoutUsuarioInput>
  }

  export type TrocaUncheckedUpdateManyWithoutUsuarioNestedInput = {
    create?: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput> | TrocaCreateWithoutUsuarioInput[] | TrocaUncheckedCreateWithoutUsuarioInput[]
    connectOrCreate?: TrocaCreateOrConnectWithoutUsuarioInput | TrocaCreateOrConnectWithoutUsuarioInput[]
    upsert?: TrocaUpsertWithWhereUniqueWithoutUsuarioInput | TrocaUpsertWithWhereUniqueWithoutUsuarioInput[]
    createMany?: TrocaCreateManyUsuarioInputEnvelope
    set?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    disconnect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    delete?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    connect?: TrocaWhereUniqueInput | TrocaWhereUniqueInput[]
    update?: TrocaUpdateWithWhereUniqueWithoutUsuarioInput | TrocaUpdateWithWhereUniqueWithoutUsuarioInput[]
    updateMany?: TrocaUpdateManyWithWhereWithoutUsuarioInput | TrocaUpdateManyWithWhereWithoutUsuarioInput[]
    deleteMany?: TrocaScalarWhereInput | TrocaScalarWhereInput[]
  }

  export type CartaoUsuarioUncheckedUpdateOneWithoutUsuarioNestedInput = {
    create?: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutUsuarioInput
    upsert?: CartaoUsuarioUpsertWithoutUsuarioInput
    disconnect?: CartaoUsuarioWhereInput | boolean
    delete?: CartaoUsuarioWhereInput | boolean
    connect?: CartaoUsuarioWhereUniqueInput
    update?: XOR<XOR<CartaoUsuarioUpdateToOneWithWhereWithoutUsuarioInput, CartaoUsuarioUpdateWithoutUsuarioInput>, CartaoUsuarioUncheckedUpdateWithoutUsuarioInput>
  }

  export type CartaoUsuarioCreateNestedOneWithoutCartaoInput = {
    create?: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutCartaoInput
    connect?: CartaoUsuarioWhereUniqueInput
  }

  export type CartaoUsuarioUncheckedCreateNestedOneWithoutCartaoInput = {
    create?: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutCartaoInput
    connect?: CartaoUsuarioWhereUniqueInput
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type CartaoUsuarioUpdateOneWithoutCartaoNestedInput = {
    create?: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutCartaoInput
    upsert?: CartaoUsuarioUpsertWithoutCartaoInput
    disconnect?: CartaoUsuarioWhereInput | boolean
    delete?: CartaoUsuarioWhereInput | boolean
    connect?: CartaoUsuarioWhereUniqueInput
    update?: XOR<XOR<CartaoUsuarioUpdateToOneWithWhereWithoutCartaoInput, CartaoUsuarioUpdateWithoutCartaoInput>, CartaoUsuarioUncheckedUpdateWithoutCartaoInput>
  }

  export type CartaoUsuarioUncheckedUpdateOneWithoutCartaoNestedInput = {
    create?: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
    connectOrCreate?: CartaoUsuarioCreateOrConnectWithoutCartaoInput
    upsert?: CartaoUsuarioUpsertWithoutCartaoInput
    disconnect?: CartaoUsuarioWhereInput | boolean
    delete?: CartaoUsuarioWhereInput | boolean
    connect?: CartaoUsuarioWhereUniqueInput
    update?: XOR<XOR<CartaoUsuarioUpdateToOneWithWhereWithoutCartaoInput, CartaoUsuarioUpdateWithoutCartaoInput>, CartaoUsuarioUncheckedUpdateWithoutCartaoInput>
  }

  export type CartaoCreateNestedOneWithoutCartao_usuarioInput = {
    create?: XOR<CartaoCreateWithoutCartao_usuarioInput, CartaoUncheckedCreateWithoutCartao_usuarioInput>
    connectOrCreate?: CartaoCreateOrConnectWithoutCartao_usuarioInput
    connect?: CartaoWhereUniqueInput
  }

  export type UsuarioCreateNestedOneWithoutCartao_usuarioInput = {
    create?: XOR<UsuarioCreateWithoutCartao_usuarioInput, UsuarioUncheckedCreateWithoutCartao_usuarioInput>
    connectOrCreate?: UsuarioCreateOrConnectWithoutCartao_usuarioInput
    connect?: UsuarioWhereUniqueInput
  }

  export type CartaoUpdateOneRequiredWithoutCartao_usuarioNestedInput = {
    create?: XOR<CartaoCreateWithoutCartao_usuarioInput, CartaoUncheckedCreateWithoutCartao_usuarioInput>
    connectOrCreate?: CartaoCreateOrConnectWithoutCartao_usuarioInput
    upsert?: CartaoUpsertWithoutCartao_usuarioInput
    connect?: CartaoWhereUniqueInput
    update?: XOR<XOR<CartaoUpdateToOneWithWhereWithoutCartao_usuarioInput, CartaoUpdateWithoutCartao_usuarioInput>, CartaoUncheckedUpdateWithoutCartao_usuarioInput>
  }

  export type UsuarioUpdateOneRequiredWithoutCartao_usuarioNestedInput = {
    create?: XOR<UsuarioCreateWithoutCartao_usuarioInput, UsuarioUncheckedCreateWithoutCartao_usuarioInput>
    connectOrCreate?: UsuarioCreateOrConnectWithoutCartao_usuarioInput
    upsert?: UsuarioUpsertWithoutCartao_usuarioInput
    connect?: UsuarioWhereUniqueInput
    update?: XOR<XOR<UsuarioUpdateToOneWithWhereWithoutCartao_usuarioInput, UsuarioUpdateWithoutCartao_usuarioInput>, UsuarioUncheckedUpdateWithoutCartao_usuarioInput>
  }

  export type BeneficioCreateNestedOneWithoutReferenciasInput = {
    create?: XOR<BeneficioCreateWithoutReferenciasInput, BeneficioUncheckedCreateWithoutReferenciasInput>
    connectOrCreate?: BeneficioCreateOrConnectWithoutReferenciasInput
    connect?: BeneficioWhereUniqueInput
  }

  export type TrocaCreateNestedOneWithoutReferenciaInput = {
    create?: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
    connectOrCreate?: TrocaCreateOrConnectWithoutReferenciaInput
    connect?: TrocaWhereUniqueInput
  }

  export type TrocaUncheckedCreateNestedOneWithoutReferenciaInput = {
    create?: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
    connectOrCreate?: TrocaCreateOrConnectWithoutReferenciaInput
    connect?: TrocaWhereUniqueInput
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type BeneficioUpdateOneRequiredWithoutReferenciasNestedInput = {
    create?: XOR<BeneficioCreateWithoutReferenciasInput, BeneficioUncheckedCreateWithoutReferenciasInput>
    connectOrCreate?: BeneficioCreateOrConnectWithoutReferenciasInput
    upsert?: BeneficioUpsertWithoutReferenciasInput
    connect?: BeneficioWhereUniqueInput
    update?: XOR<XOR<BeneficioUpdateToOneWithWhereWithoutReferenciasInput, BeneficioUpdateWithoutReferenciasInput>, BeneficioUncheckedUpdateWithoutReferenciasInput>
  }

  export type TrocaUpdateOneWithoutReferenciaNestedInput = {
    create?: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
    connectOrCreate?: TrocaCreateOrConnectWithoutReferenciaInput
    upsert?: TrocaUpsertWithoutReferenciaInput
    disconnect?: TrocaWhereInput | boolean
    delete?: TrocaWhereInput | boolean
    connect?: TrocaWhereUniqueInput
    update?: XOR<XOR<TrocaUpdateToOneWithWhereWithoutReferenciaInput, TrocaUpdateWithoutReferenciaInput>, TrocaUncheckedUpdateWithoutReferenciaInput>
  }

  export type TrocaUncheckedUpdateOneWithoutReferenciaNestedInput = {
    create?: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
    connectOrCreate?: TrocaCreateOrConnectWithoutReferenciaInput
    upsert?: TrocaUpsertWithoutReferenciaInput
    disconnect?: TrocaWhereInput | boolean
    delete?: TrocaWhereInput | boolean
    connect?: TrocaWhereUniqueInput
    update?: XOR<XOR<TrocaUpdateToOneWithWhereWithoutReferenciaInput, TrocaUpdateWithoutReferenciaInput>, TrocaUncheckedUpdateWithoutReferenciaInput>
  }

  export type CategoriaCreateNestedOneWithoutBeneficiosInput = {
    create?: XOR<CategoriaCreateWithoutBeneficiosInput, CategoriaUncheckedCreateWithoutBeneficiosInput>
    connectOrCreate?: CategoriaCreateOrConnectWithoutBeneficiosInput
    connect?: CategoriaWhereUniqueInput
  }

  export type ReferenciaCreateNestedManyWithoutBeneficioInput = {
    create?: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput> | ReferenciaCreateWithoutBeneficioInput[] | ReferenciaUncheckedCreateWithoutBeneficioInput[]
    connectOrCreate?: ReferenciaCreateOrConnectWithoutBeneficioInput | ReferenciaCreateOrConnectWithoutBeneficioInput[]
    createMany?: ReferenciaCreateManyBeneficioInputEnvelope
    connect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
  }

  export type ReferenciaUncheckedCreateNestedManyWithoutBeneficioInput = {
    create?: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput> | ReferenciaCreateWithoutBeneficioInput[] | ReferenciaUncheckedCreateWithoutBeneficioInput[]
    connectOrCreate?: ReferenciaCreateOrConnectWithoutBeneficioInput | ReferenciaCreateOrConnectWithoutBeneficioInput[]
    createMany?: ReferenciaCreateManyBeneficioInputEnvelope
    connect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
  }

  export type CategoriaUpdateOneRequiredWithoutBeneficiosNestedInput = {
    create?: XOR<CategoriaCreateWithoutBeneficiosInput, CategoriaUncheckedCreateWithoutBeneficiosInput>
    connectOrCreate?: CategoriaCreateOrConnectWithoutBeneficiosInput
    upsert?: CategoriaUpsertWithoutBeneficiosInput
    connect?: CategoriaWhereUniqueInput
    update?: XOR<XOR<CategoriaUpdateToOneWithWhereWithoutBeneficiosInput, CategoriaUpdateWithoutBeneficiosInput>, CategoriaUncheckedUpdateWithoutBeneficiosInput>
  }

  export type ReferenciaUpdateManyWithoutBeneficioNestedInput = {
    create?: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput> | ReferenciaCreateWithoutBeneficioInput[] | ReferenciaUncheckedCreateWithoutBeneficioInput[]
    connectOrCreate?: ReferenciaCreateOrConnectWithoutBeneficioInput | ReferenciaCreateOrConnectWithoutBeneficioInput[]
    upsert?: ReferenciaUpsertWithWhereUniqueWithoutBeneficioInput | ReferenciaUpsertWithWhereUniqueWithoutBeneficioInput[]
    createMany?: ReferenciaCreateManyBeneficioInputEnvelope
    set?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    disconnect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    delete?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    connect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    update?: ReferenciaUpdateWithWhereUniqueWithoutBeneficioInput | ReferenciaUpdateWithWhereUniqueWithoutBeneficioInput[]
    updateMany?: ReferenciaUpdateManyWithWhereWithoutBeneficioInput | ReferenciaUpdateManyWithWhereWithoutBeneficioInput[]
    deleteMany?: ReferenciaScalarWhereInput | ReferenciaScalarWhereInput[]
  }

  export type ReferenciaUncheckedUpdateManyWithoutBeneficioNestedInput = {
    create?: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput> | ReferenciaCreateWithoutBeneficioInput[] | ReferenciaUncheckedCreateWithoutBeneficioInput[]
    connectOrCreate?: ReferenciaCreateOrConnectWithoutBeneficioInput | ReferenciaCreateOrConnectWithoutBeneficioInput[]
    upsert?: ReferenciaUpsertWithWhereUniqueWithoutBeneficioInput | ReferenciaUpsertWithWhereUniqueWithoutBeneficioInput[]
    createMany?: ReferenciaCreateManyBeneficioInputEnvelope
    set?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    disconnect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    delete?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    connect?: ReferenciaWhereUniqueInput | ReferenciaWhereUniqueInput[]
    update?: ReferenciaUpdateWithWhereUniqueWithoutBeneficioInput | ReferenciaUpdateWithWhereUniqueWithoutBeneficioInput[]
    updateMany?: ReferenciaUpdateManyWithWhereWithoutBeneficioInput | ReferenciaUpdateManyWithWhereWithoutBeneficioInput[]
    deleteMany?: ReferenciaScalarWhereInput | ReferenciaScalarWhereInput[]
  }

  export type BeneficioCreateNestedManyWithoutCategoriaInput = {
    create?: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput> | BeneficioCreateWithoutCategoriaInput[] | BeneficioUncheckedCreateWithoutCategoriaInput[]
    connectOrCreate?: BeneficioCreateOrConnectWithoutCategoriaInput | BeneficioCreateOrConnectWithoutCategoriaInput[]
    createMany?: BeneficioCreateManyCategoriaInputEnvelope
    connect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
  }

  export type BeneficioUncheckedCreateNestedManyWithoutCategoriaInput = {
    create?: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput> | BeneficioCreateWithoutCategoriaInput[] | BeneficioUncheckedCreateWithoutCategoriaInput[]
    connectOrCreate?: BeneficioCreateOrConnectWithoutCategoriaInput | BeneficioCreateOrConnectWithoutCategoriaInput[]
    createMany?: BeneficioCreateManyCategoriaInputEnvelope
    connect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
  }

  export type BeneficioUpdateManyWithoutCategoriaNestedInput = {
    create?: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput> | BeneficioCreateWithoutCategoriaInput[] | BeneficioUncheckedCreateWithoutCategoriaInput[]
    connectOrCreate?: BeneficioCreateOrConnectWithoutCategoriaInput | BeneficioCreateOrConnectWithoutCategoriaInput[]
    upsert?: BeneficioUpsertWithWhereUniqueWithoutCategoriaInput | BeneficioUpsertWithWhereUniqueWithoutCategoriaInput[]
    createMany?: BeneficioCreateManyCategoriaInputEnvelope
    set?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    disconnect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    delete?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    connect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    update?: BeneficioUpdateWithWhereUniqueWithoutCategoriaInput | BeneficioUpdateWithWhereUniqueWithoutCategoriaInput[]
    updateMany?: BeneficioUpdateManyWithWhereWithoutCategoriaInput | BeneficioUpdateManyWithWhereWithoutCategoriaInput[]
    deleteMany?: BeneficioScalarWhereInput | BeneficioScalarWhereInput[]
  }

  export type BeneficioUncheckedUpdateManyWithoutCategoriaNestedInput = {
    create?: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput> | BeneficioCreateWithoutCategoriaInput[] | BeneficioUncheckedCreateWithoutCategoriaInput[]
    connectOrCreate?: BeneficioCreateOrConnectWithoutCategoriaInput | BeneficioCreateOrConnectWithoutCategoriaInput[]
    upsert?: BeneficioUpsertWithWhereUniqueWithoutCategoriaInput | BeneficioUpsertWithWhereUniqueWithoutCategoriaInput[]
    createMany?: BeneficioCreateManyCategoriaInputEnvelope
    set?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    disconnect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    delete?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    connect?: BeneficioWhereUniqueInput | BeneficioWhereUniqueInput[]
    update?: BeneficioUpdateWithWhereUniqueWithoutCategoriaInput | BeneficioUpdateWithWhereUniqueWithoutCategoriaInput[]
    updateMany?: BeneficioUpdateManyWithWhereWithoutCategoriaInput | BeneficioUpdateManyWithWhereWithoutCategoriaInput[]
    deleteMany?: BeneficioScalarWhereInput | BeneficioScalarWhereInput[]
  }

  export type UsuarioCreateNestedOneWithoutTrocasInput = {
    create?: XOR<UsuarioCreateWithoutTrocasInput, UsuarioUncheckedCreateWithoutTrocasInput>
    connectOrCreate?: UsuarioCreateOrConnectWithoutTrocasInput
    connect?: UsuarioWhereUniqueInput
  }

  export type ReferenciaCreateNestedOneWithoutTrocaInput = {
    create?: XOR<ReferenciaCreateWithoutTrocaInput, ReferenciaUncheckedCreateWithoutTrocaInput>
    connectOrCreate?: ReferenciaCreateOrConnectWithoutTrocaInput
    connect?: ReferenciaWhereUniqueInput
  }

  export type UsuarioUpdateOneRequiredWithoutTrocasNestedInput = {
    create?: XOR<UsuarioCreateWithoutTrocasInput, UsuarioUncheckedCreateWithoutTrocasInput>
    connectOrCreate?: UsuarioCreateOrConnectWithoutTrocasInput
    upsert?: UsuarioUpsertWithoutTrocasInput
    connect?: UsuarioWhereUniqueInput
    update?: XOR<XOR<UsuarioUpdateToOneWithWhereWithoutTrocasInput, UsuarioUpdateWithoutTrocasInput>, UsuarioUncheckedUpdateWithoutTrocasInput>
  }

  export type ReferenciaUpdateOneRequiredWithoutTrocaNestedInput = {
    create?: XOR<ReferenciaCreateWithoutTrocaInput, ReferenciaUncheckedCreateWithoutTrocaInput>
    connectOrCreate?: ReferenciaCreateOrConnectWithoutTrocaInput
    upsert?: ReferenciaUpsertWithoutTrocaInput
    connect?: ReferenciaWhereUniqueInput
    update?: XOR<XOR<ReferenciaUpdateToOneWithWhereWithoutTrocaInput, ReferenciaUpdateWithoutTrocaInput>, ReferenciaUncheckedUpdateWithoutTrocaInput>
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedBoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type NestedBoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[]
    notIn?: Date[] | string[]
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type TrocaCreateWithoutUsuarioInput = {
    id?: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
    referencia: ReferenciaCreateNestedOneWithoutTrocaInput
  }

  export type TrocaUncheckedCreateWithoutUsuarioInput = {
    id?: string
    id_referencia: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
  }

  export type TrocaCreateOrConnectWithoutUsuarioInput = {
    where: TrocaWhereUniqueInput
    create: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput>
  }

  export type TrocaCreateManyUsuarioInputEnvelope = {
    data: TrocaCreateManyUsuarioInput | TrocaCreateManyUsuarioInput[]
    skipDuplicates?: boolean
  }

  export type CartaoUsuarioCreateWithoutUsuarioInput = {
    id?: string
    estado?: boolean
    cartao: CartaoCreateNestedOneWithoutCartao_usuarioInput
  }

  export type CartaoUsuarioUncheckedCreateWithoutUsuarioInput = {
    id?: string
    id_cartao: string
    estado?: boolean
  }

  export type CartaoUsuarioCreateOrConnectWithoutUsuarioInput = {
    where: CartaoUsuarioWhereUniqueInput
    create: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
  }

  export type TrocaUpsertWithWhereUniqueWithoutUsuarioInput = {
    where: TrocaWhereUniqueInput
    update: XOR<TrocaUpdateWithoutUsuarioInput, TrocaUncheckedUpdateWithoutUsuarioInput>
    create: XOR<TrocaCreateWithoutUsuarioInput, TrocaUncheckedCreateWithoutUsuarioInput>
  }

  export type TrocaUpdateWithWhereUniqueWithoutUsuarioInput = {
    where: TrocaWhereUniqueInput
    data: XOR<TrocaUpdateWithoutUsuarioInput, TrocaUncheckedUpdateWithoutUsuarioInput>
  }

  export type TrocaUpdateManyWithWhereWithoutUsuarioInput = {
    where: TrocaScalarWhereInput
    data: XOR<TrocaUpdateManyMutationInput, TrocaUncheckedUpdateManyWithoutUsuarioInput>
  }

  export type TrocaScalarWhereInput = {
    AND?: TrocaScalarWhereInput | TrocaScalarWhereInput[]
    OR?: TrocaScalarWhereInput[]
    NOT?: TrocaScalarWhereInput | TrocaScalarWhereInput[]
    id?: StringFilter<"Troca"> | string
    id_referencia?: StringFilter<"Troca"> | string
    id_usuario?: StringFilter<"Troca"> | string
    email?: StringNullableFilter<"Troca"> | string | null
    telefone?: StringNullableFilter<"Troca"> | string | null
    data?: DateTimeFilter<"Troca"> | Date | string
  }

  export type CartaoUsuarioUpsertWithoutUsuarioInput = {
    update: XOR<CartaoUsuarioUpdateWithoutUsuarioInput, CartaoUsuarioUncheckedUpdateWithoutUsuarioInput>
    create: XOR<CartaoUsuarioCreateWithoutUsuarioInput, CartaoUsuarioUncheckedCreateWithoutUsuarioInput>
    where?: CartaoUsuarioWhereInput
  }

  export type CartaoUsuarioUpdateToOneWithWhereWithoutUsuarioInput = {
    where?: CartaoUsuarioWhereInput
    data: XOR<CartaoUsuarioUpdateWithoutUsuarioInput, CartaoUsuarioUncheckedUpdateWithoutUsuarioInput>
  }

  export type CartaoUsuarioUpdateWithoutUsuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
    cartao?: CartaoUpdateOneRequiredWithoutCartao_usuarioNestedInput
  }

  export type CartaoUsuarioUncheckedUpdateWithoutUsuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_cartao?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUsuarioCreateWithoutCartaoInput = {
    id?: string
    estado?: boolean
    usuario: UsuarioCreateNestedOneWithoutCartao_usuarioInput
  }

  export type CartaoUsuarioUncheckedCreateWithoutCartaoInput = {
    id?: string
    id_usuario: string
    estado?: boolean
  }

  export type CartaoUsuarioCreateOrConnectWithoutCartaoInput = {
    where: CartaoUsuarioWhereUniqueInput
    create: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
  }

  export type CartaoUsuarioUpsertWithoutCartaoInput = {
    update: XOR<CartaoUsuarioUpdateWithoutCartaoInput, CartaoUsuarioUncheckedUpdateWithoutCartaoInput>
    create: XOR<CartaoUsuarioCreateWithoutCartaoInput, CartaoUsuarioUncheckedCreateWithoutCartaoInput>
    where?: CartaoUsuarioWhereInput
  }

  export type CartaoUsuarioUpdateToOneWithWhereWithoutCartaoInput = {
    where?: CartaoUsuarioWhereInput
    data: XOR<CartaoUsuarioUpdateWithoutCartaoInput, CartaoUsuarioUncheckedUpdateWithoutCartaoInput>
  }

  export type CartaoUsuarioUpdateWithoutCartaoInput = {
    id?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
    usuario?: UsuarioUpdateOneRequiredWithoutCartao_usuarioNestedInput
  }

  export type CartaoUsuarioUncheckedUpdateWithoutCartaoInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoCreateWithoutCartao_usuarioInput = {
    id?: string
    numero: string
    estado?: boolean
  }

  export type CartaoUncheckedCreateWithoutCartao_usuarioInput = {
    id?: string
    numero: string
    estado?: boolean
  }

  export type CartaoCreateOrConnectWithoutCartao_usuarioInput = {
    where: CartaoWhereUniqueInput
    create: XOR<CartaoCreateWithoutCartao_usuarioInput, CartaoUncheckedCreateWithoutCartao_usuarioInput>
  }

  export type UsuarioCreateWithoutCartao_usuarioInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    trocas?: TrocaCreateNestedManyWithoutUsuarioInput
  }

  export type UsuarioUncheckedCreateWithoutCartao_usuarioInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    trocas?: TrocaUncheckedCreateNestedManyWithoutUsuarioInput
  }

  export type UsuarioCreateOrConnectWithoutCartao_usuarioInput = {
    where: UsuarioWhereUniqueInput
    create: XOR<UsuarioCreateWithoutCartao_usuarioInput, UsuarioUncheckedCreateWithoutCartao_usuarioInput>
  }

  export type CartaoUpsertWithoutCartao_usuarioInput = {
    update: XOR<CartaoUpdateWithoutCartao_usuarioInput, CartaoUncheckedUpdateWithoutCartao_usuarioInput>
    create: XOR<CartaoCreateWithoutCartao_usuarioInput, CartaoUncheckedCreateWithoutCartao_usuarioInput>
    where?: CartaoWhereInput
  }

  export type CartaoUpdateToOneWithWhereWithoutCartao_usuarioInput = {
    where?: CartaoWhereInput
    data: XOR<CartaoUpdateWithoutCartao_usuarioInput, CartaoUncheckedUpdateWithoutCartao_usuarioInput>
  }

  export type CartaoUpdateWithoutCartao_usuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type CartaoUncheckedUpdateWithoutCartao_usuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    numero?: StringFieldUpdateOperationsInput | string
    estado?: BoolFieldUpdateOperationsInput | boolean
  }

  export type UsuarioUpsertWithoutCartao_usuarioInput = {
    update: XOR<UsuarioUpdateWithoutCartao_usuarioInput, UsuarioUncheckedUpdateWithoutCartao_usuarioInput>
    create: XOR<UsuarioCreateWithoutCartao_usuarioInput, UsuarioUncheckedCreateWithoutCartao_usuarioInput>
    where?: UsuarioWhereInput
  }

  export type UsuarioUpdateToOneWithWhereWithoutCartao_usuarioInput = {
    where?: UsuarioWhereInput
    data: XOR<UsuarioUpdateWithoutCartao_usuarioInput, UsuarioUncheckedUpdateWithoutCartao_usuarioInput>
  }

  export type UsuarioUpdateWithoutCartao_usuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    trocas?: TrocaUpdateManyWithoutUsuarioNestedInput
  }

  export type UsuarioUncheckedUpdateWithoutCartao_usuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    trocas?: TrocaUncheckedUpdateManyWithoutUsuarioNestedInput
  }

  export type BeneficioCreateWithoutReferenciasInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    created_at?: Date | string
    categoria: CategoriaCreateNestedOneWithoutBeneficiosInput
  }

  export type BeneficioUncheckedCreateWithoutReferenciasInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    id_categoria: string
    created_at?: Date | string
  }

  export type BeneficioCreateOrConnectWithoutReferenciasInput = {
    where: BeneficioWhereUniqueInput
    create: XOR<BeneficioCreateWithoutReferenciasInput, BeneficioUncheckedCreateWithoutReferenciasInput>
  }

  export type TrocaCreateWithoutReferenciaInput = {
    id?: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
    usuario: UsuarioCreateNestedOneWithoutTrocasInput
  }

  export type TrocaUncheckedCreateWithoutReferenciaInput = {
    id?: string
    id_usuario: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
  }

  export type TrocaCreateOrConnectWithoutReferenciaInput = {
    where: TrocaWhereUniqueInput
    create: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
  }

  export type BeneficioUpsertWithoutReferenciasInput = {
    update: XOR<BeneficioUpdateWithoutReferenciasInput, BeneficioUncheckedUpdateWithoutReferenciasInput>
    create: XOR<BeneficioCreateWithoutReferenciasInput, BeneficioUncheckedCreateWithoutReferenciasInput>
    where?: BeneficioWhereInput
  }

  export type BeneficioUpdateToOneWithWhereWithoutReferenciasInput = {
    where?: BeneficioWhereInput
    data: XOR<BeneficioUpdateWithoutReferenciasInput, BeneficioUncheckedUpdateWithoutReferenciasInput>
  }

  export type BeneficioUpdateWithoutReferenciasInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    categoria?: CategoriaUpdateOneRequiredWithoutBeneficiosNestedInput
  }

  export type BeneficioUncheckedUpdateWithoutReferenciasInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    id_categoria?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TrocaUpsertWithoutReferenciaInput = {
    update: XOR<TrocaUpdateWithoutReferenciaInput, TrocaUncheckedUpdateWithoutReferenciaInput>
    create: XOR<TrocaCreateWithoutReferenciaInput, TrocaUncheckedCreateWithoutReferenciaInput>
    where?: TrocaWhereInput
  }

  export type TrocaUpdateToOneWithWhereWithoutReferenciaInput = {
    where?: TrocaWhereInput
    data: XOR<TrocaUpdateWithoutReferenciaInput, TrocaUncheckedUpdateWithoutReferenciaInput>
  }

  export type TrocaUpdateWithoutReferenciaInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    usuario?: UsuarioUpdateOneRequiredWithoutTrocasNestedInput
  }

  export type TrocaUncheckedUpdateWithoutReferenciaInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_usuario?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type CategoriaCreateWithoutBeneficiosInput = {
    id?: string
    nome: string
    descricao: string
  }

  export type CategoriaUncheckedCreateWithoutBeneficiosInput = {
    id?: string
    nome: string
    descricao: string
  }

  export type CategoriaCreateOrConnectWithoutBeneficiosInput = {
    where: CategoriaWhereUniqueInput
    create: XOR<CategoriaCreateWithoutBeneficiosInput, CategoriaUncheckedCreateWithoutBeneficiosInput>
  }

  export type ReferenciaCreateWithoutBeneficioInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    troca?: TrocaCreateNestedOneWithoutReferenciaInput
  }

  export type ReferenciaUncheckedCreateWithoutBeneficioInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    troca?: TrocaUncheckedCreateNestedOneWithoutReferenciaInput
  }

  export type ReferenciaCreateOrConnectWithoutBeneficioInput = {
    where: ReferenciaWhereUniqueInput
    create: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput>
  }

  export type ReferenciaCreateManyBeneficioInputEnvelope = {
    data: ReferenciaCreateManyBeneficioInput | ReferenciaCreateManyBeneficioInput[]
    skipDuplicates?: boolean
  }

  export type CategoriaUpsertWithoutBeneficiosInput = {
    update: XOR<CategoriaUpdateWithoutBeneficiosInput, CategoriaUncheckedUpdateWithoutBeneficiosInput>
    create: XOR<CategoriaCreateWithoutBeneficiosInput, CategoriaUncheckedCreateWithoutBeneficiosInput>
    where?: CategoriaWhereInput
  }

  export type CategoriaUpdateToOneWithWhereWithoutBeneficiosInput = {
    where?: CategoriaWhereInput
    data: XOR<CategoriaUpdateWithoutBeneficiosInput, CategoriaUncheckedUpdateWithoutBeneficiosInput>
  }

  export type CategoriaUpdateWithoutBeneficiosInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
  }

  export type CategoriaUncheckedUpdateWithoutBeneficiosInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
  }

  export type ReferenciaUpsertWithWhereUniqueWithoutBeneficioInput = {
    where: ReferenciaWhereUniqueInput
    update: XOR<ReferenciaUpdateWithoutBeneficioInput, ReferenciaUncheckedUpdateWithoutBeneficioInput>
    create: XOR<ReferenciaCreateWithoutBeneficioInput, ReferenciaUncheckedCreateWithoutBeneficioInput>
  }

  export type ReferenciaUpdateWithWhereUniqueWithoutBeneficioInput = {
    where: ReferenciaWhereUniqueInput
    data: XOR<ReferenciaUpdateWithoutBeneficioInput, ReferenciaUncheckedUpdateWithoutBeneficioInput>
  }

  export type ReferenciaUpdateManyWithWhereWithoutBeneficioInput = {
    where: ReferenciaScalarWhereInput
    data: XOR<ReferenciaUpdateManyMutationInput, ReferenciaUncheckedUpdateManyWithoutBeneficioInput>
  }

  export type ReferenciaScalarWhereInput = {
    AND?: ReferenciaScalarWhereInput | ReferenciaScalarWhereInput[]
    OR?: ReferenciaScalarWhereInput[]
    NOT?: ReferenciaScalarWhereInput | ReferenciaScalarWhereInput[]
    id?: StringFilter<"Referencia"> | string
    codigo?: StringFilter<"Referencia"> | string
    usado?: BoolFilter<"Referencia"> | boolean
    data?: DateTimeFilter<"Referencia"> | Date | string
    id_beneficio?: StringFilter<"Referencia"> | string
  }

  export type BeneficioCreateWithoutCategoriaInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    created_at?: Date | string
    referencias?: ReferenciaCreateNestedManyWithoutBeneficioInput
  }

  export type BeneficioUncheckedCreateWithoutCategoriaInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    created_at?: Date | string
    referencias?: ReferenciaUncheckedCreateNestedManyWithoutBeneficioInput
  }

  export type BeneficioCreateOrConnectWithoutCategoriaInput = {
    where: BeneficioWhereUniqueInput
    create: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput>
  }

  export type BeneficioCreateManyCategoriaInputEnvelope = {
    data: BeneficioCreateManyCategoriaInput | BeneficioCreateManyCategoriaInput[]
    skipDuplicates?: boolean
  }

  export type BeneficioUpsertWithWhereUniqueWithoutCategoriaInput = {
    where: BeneficioWhereUniqueInput
    update: XOR<BeneficioUpdateWithoutCategoriaInput, BeneficioUncheckedUpdateWithoutCategoriaInput>
    create: XOR<BeneficioCreateWithoutCategoriaInput, BeneficioUncheckedCreateWithoutCategoriaInput>
  }

  export type BeneficioUpdateWithWhereUniqueWithoutCategoriaInput = {
    where: BeneficioWhereUniqueInput
    data: XOR<BeneficioUpdateWithoutCategoriaInput, BeneficioUncheckedUpdateWithoutCategoriaInput>
  }

  export type BeneficioUpdateManyWithWhereWithoutCategoriaInput = {
    where: BeneficioScalarWhereInput
    data: XOR<BeneficioUpdateManyMutationInput, BeneficioUncheckedUpdateManyWithoutCategoriaInput>
  }

  export type BeneficioScalarWhereInput = {
    AND?: BeneficioScalarWhereInput | BeneficioScalarWhereInput[]
    OR?: BeneficioScalarWhereInput[]
    NOT?: BeneficioScalarWhereInput | BeneficioScalarWhereInput[]
    id?: StringFilter<"Beneficio"> | string
    nome?: StringFilter<"Beneficio"> | string
    descricao?: StringFilter<"Beneficio"> | string
    pontos?: IntFilter<"Beneficio"> | number
    estado?: BoolFilter<"Beneficio"> | boolean
    id_categoria?: StringFilter<"Beneficio"> | string
    created_at?: DateTimeFilter<"Beneficio"> | Date | string
  }

  export type UsuarioCreateWithoutTrocasInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    cartao_usuario?: CartaoUsuarioCreateNestedOneWithoutUsuarioInput
  }

  export type UsuarioUncheckedCreateWithoutTrocasInput = {
    id?: string
    nome: string
    email: string
    email_recuperacao?: string | null
    senha: string
    telefone: string
    pontos?: number
    foto?: string | null
    tipo?: string
    cartao_usuario?: CartaoUsuarioUncheckedCreateNestedOneWithoutUsuarioInput
  }

  export type UsuarioCreateOrConnectWithoutTrocasInput = {
    where: UsuarioWhereUniqueInput
    create: XOR<UsuarioCreateWithoutTrocasInput, UsuarioUncheckedCreateWithoutTrocasInput>
  }

  export type ReferenciaCreateWithoutTrocaInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    beneficio: BeneficioCreateNestedOneWithoutReferenciasInput
  }

  export type ReferenciaUncheckedCreateWithoutTrocaInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
    id_beneficio: string
  }

  export type ReferenciaCreateOrConnectWithoutTrocaInput = {
    where: ReferenciaWhereUniqueInput
    create: XOR<ReferenciaCreateWithoutTrocaInput, ReferenciaUncheckedCreateWithoutTrocaInput>
  }

  export type UsuarioUpsertWithoutTrocasInput = {
    update: XOR<UsuarioUpdateWithoutTrocasInput, UsuarioUncheckedUpdateWithoutTrocasInput>
    create: XOR<UsuarioCreateWithoutTrocasInput, UsuarioUncheckedCreateWithoutTrocasInput>
    where?: UsuarioWhereInput
  }

  export type UsuarioUpdateToOneWithWhereWithoutTrocasInput = {
    where?: UsuarioWhereInput
    data: XOR<UsuarioUpdateWithoutTrocasInput, UsuarioUncheckedUpdateWithoutTrocasInput>
  }

  export type UsuarioUpdateWithoutTrocasInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    cartao_usuario?: CartaoUsuarioUpdateOneWithoutUsuarioNestedInput
  }

  export type UsuarioUncheckedUpdateWithoutTrocasInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    email_recuperacao?: NullableStringFieldUpdateOperationsInput | string | null
    senha?: StringFieldUpdateOperationsInput | string
    telefone?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    foto?: NullableStringFieldUpdateOperationsInput | string | null
    tipo?: StringFieldUpdateOperationsInput | string
    cartao_usuario?: CartaoUsuarioUncheckedUpdateOneWithoutUsuarioNestedInput
  }

  export type ReferenciaUpsertWithoutTrocaInput = {
    update: XOR<ReferenciaUpdateWithoutTrocaInput, ReferenciaUncheckedUpdateWithoutTrocaInput>
    create: XOR<ReferenciaCreateWithoutTrocaInput, ReferenciaUncheckedCreateWithoutTrocaInput>
    where?: ReferenciaWhereInput
  }

  export type ReferenciaUpdateToOneWithWhereWithoutTrocaInput = {
    where?: ReferenciaWhereInput
    data: XOR<ReferenciaUpdateWithoutTrocaInput, ReferenciaUncheckedUpdateWithoutTrocaInput>
  }

  export type ReferenciaUpdateWithoutTrocaInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    beneficio?: BeneficioUpdateOneRequiredWithoutReferenciasNestedInput
  }

  export type ReferenciaUncheckedUpdateWithoutTrocaInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    id_beneficio?: StringFieldUpdateOperationsInput | string
  }

  export type TrocaCreateManyUsuarioInput = {
    id?: string
    id_referencia: string
    email?: string | null
    telefone?: string | null
    data?: Date | string
  }

  export type TrocaUpdateWithoutUsuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    referencia?: ReferenciaUpdateOneRequiredWithoutTrocaNestedInput
  }

  export type TrocaUncheckedUpdateWithoutUsuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_referencia?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type TrocaUncheckedUpdateManyWithoutUsuarioInput = {
    id?: StringFieldUpdateOperationsInput | string
    id_referencia?: StringFieldUpdateOperationsInput | string
    email?: NullableStringFieldUpdateOperationsInput | string | null
    telefone?: NullableStringFieldUpdateOperationsInput | string | null
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type ReferenciaCreateManyBeneficioInput = {
    id?: string
    codigo: string
    usado?: boolean
    data?: Date | string
  }

  export type ReferenciaUpdateWithoutBeneficioInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    troca?: TrocaUpdateOneWithoutReferenciaNestedInput
  }

  export type ReferenciaUncheckedUpdateWithoutBeneficioInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
    troca?: TrocaUncheckedUpdateOneWithoutReferenciaNestedInput
  }

  export type ReferenciaUncheckedUpdateManyWithoutBeneficioInput = {
    id?: StringFieldUpdateOperationsInput | string
    codigo?: StringFieldUpdateOperationsInput | string
    usado?: BoolFieldUpdateOperationsInput | boolean
    data?: DateTimeFieldUpdateOperationsInput | Date | string
  }

  export type BeneficioCreateManyCategoriaInput = {
    id?: string
    nome: string
    descricao?: string
    pontos?: number
    estado?: boolean
    created_at?: Date | string
  }

  export type BeneficioUpdateWithoutCategoriaInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    referencias?: ReferenciaUpdateManyWithoutBeneficioNestedInput
  }

  export type BeneficioUncheckedUpdateWithoutCategoriaInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    referencias?: ReferenciaUncheckedUpdateManyWithoutBeneficioNestedInput
  }

  export type BeneficioUncheckedUpdateManyWithoutCategoriaInput = {
    id?: StringFieldUpdateOperationsInput | string
    nome?: StringFieldUpdateOperationsInput | string
    descricao?: StringFieldUpdateOperationsInput | string
    pontos?: IntFieldUpdateOperationsInput | number
    estado?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}