import { Prisma, Referencia } from "@prisma/client";
import { BaseModel } from "./base";
import prisma from "../lib/prisma";

const referenceInclude = {
beneficio: true,
} as Prisma.ReferenciaInclude;

class ReferenceModel extends BaseModel<Referencia> {
  model = prisma.referencia;
    include = referenceInclude;
    
    getUnusedReferences = async (benefit: string) => {
        return this.model.findFirst
            ({
            where: {
                id_beneficio: benefit,
                usado: false
            },
            include: this.include
        });
    }
}

export const referenceModel = new ReferenceModel();