/**
 * Gera um template HTML para envio de credenciais por e-mail.
 * @param {string} code - O código enviado para o usuário.
 * @param {string} senha - A senha gerada para o acesso.
 * @returns {string} Template HTML formatado para envio de credenciais.
 */

export type TEmailCompleteExchange = {
  name: string;
  value: string;
  category: string;
  benefit: string;
  description: string;
  created_at: string;
  code: string;
};

export const emailCompleteExchangeTemplate = (
  data: TEmailCompleteExchange
): string => {
  return `
        <html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmação de Troca</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 90%;
        }
        .logo {
            display: block;
            margin: 0 auto 20px; 
            max-width: 250px;  
            max-height: 250px; 
        }
        h2 {
            color: #4a6350;
            font-size: 22px;
            margin-bottom: 10px;
            text-align: center;
        }
        h3 {
            color: #4a6350;
            font-size: 18px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        p, ul {
            font-size: 15px;
            color: #555;
            line-height: 1.6;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        ul li {
            margin-bottom: 8px;
        }
        ul li strong {
            color: #4a6350;
        }
        .code {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            background-color: #f4f4f4;
            padding: 12px;
            border: 1px dashed #c4d8c8;
            border-radius: 5px;
            text-align: center;
            margin-top: 10px;
            display: inline-block;
        }
        .footer {
            font-size: 14px;
            color: #777;
            text-align: center;
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="https://tuassakidila.ipil.ao/pages/assets/img/logo-tuassakidila.png" alt="Logo da Empresa" class="logo"> 
        <h2>Confirmação de Troca – Seu Código de Recarga</h2>
        <p>Olá ${data.name},</p>
        
        <p>Agradecemos por utilizar nossos serviços de troca. Estamos felizes em confirmar que sua solicitação foi processada com sucesso.</p>

        <h3>Detalhes da Troca:</h3>
        <ul>
            <li><strong>Categoria:</strong> ${data.category}</li>
            <li><strong>Serviço:</strong> ${data.benefit}</li>
            <li><strong>Descrição:</strong> ${data.description}</li>
            <li><strong>Valor da Troca:</strong> ${data.value} Pontos</li>
            <li><strong>Data da Troca:</strong> ${data.created_at}</li>
        </ul>

        <h3>Seu Código de Recarga:</h3>
        <p class="code">${data.code}</p>

        <p>Use este código para ativar sua recarga e desfrutar dos nossos serviços. Caso tenha alguma dúvida ou precise de assistência, nossa equipe de suporte está à disposição para ajudar.</p>

        <p>Agradecemos pela sua confiança e esperamos vê-lo novamente em breve!</p>

        <div class="footer">
            <p>Atenciosamente,<br>
            Tuassakidila | IPIL <br>
            tuassakidila.ipil.ao</p>
        </div>
    </div>
</body>
</html>
    `;
};

/**
 * Gera um template HTML para notificar que um e-mail foi adicionado à conta no Portal do Ipil.
 * @param {string} email - O e-mail adicionado à conta do usuário.
 * @returns {string} Template HTML formatado para notificação de e-mail adicionado.
 */
export const emailAddedNotificationTemplate = (
  email: string,
  name: string
): string => {
  return `
          <div style="max-width: 600px; margin: 0 auto; font-family: Arial, sans-serif; color: #333;">
              <h1 style="text-align: center; color: #D96F32;">Portal Ipil</h1>
              <h2 style="text-align: center;">E-mail Adicionado à Conta</h2>
              <p style="font-size: 16px; text-align: center;">
                  Informamos que o seguinte e-mail foi adicionado à sua conta no <strong>Portal do Ipil</strong>:
              </p>
              <div style="
                  background-color: #f4f4f4;
                  padding: 15px;
                  border-radius: 5px;
                  text-align: center;
                  font-size: 18px;
                  margin: 20px 0;
              ">
                  <p><strong>E-mail:</strong> ${email}</p>
                  <p><strong>Nome do proprietário da conta:</strong> ${name}</p>
                  <p><strong>Data:</strong> ${new Date().toLocaleDateString()}</p>
              </div>
              <p style="font-size: 14px; color: #777; text-align: center;">
                  Caso você não tenha realizado esta ação, entre em contato com o suporte imediatamente.
              </p>
              <p style="font-size: 14px; text-align: center; margin-top: 20px; color: #555;">
                  Obrigado por utilizar o Portal do Ipil.
              </p>
          </div>
      `;
};
