import z from "zod";
import { angolanPhoneSchema } from ".";

class ExchangeValidation {
  getData = z.object({
    telefone: z.preprocess(
      (val) => (typeof val === "string" && val.trim() === "" ? undefined : val),
      z
        .string({
          invalid_type_error: "Telefone deve ser uma string",
        })
        .optional()
        .refine(
          (value) =>
            value === undefined || angolanPhoneSchema.safeParse(value).success,
          { message: "Telefone inválido" }
        )
    ),
    email: z.preprocess(
      (val) => (typeof val === "string" && val.trim() === "" ? undefined : val),
      z.string().email("Email inválido").optional()
    ),
    id_usuario: z.string(),
    id_beneficio: z.string(),
  });
}

export const exchangeValidations = new ExchangeValidation();
