import z from "zod";
import { nonEmptyString } from ".";

class ReferenceValidation {
  getData = z.object({
    codigo: z.coerce.string({
      required_error: "O código da referência é obrigatório",
    }),
    usado: z.boolean().optional(),
    id_beneficio: nonEmptyString("O benefício é obrigatório"),
  });

  getDataToUpdate = this.getData.partial();
}

export const referenceValidations = new ReferenceValidation();
